/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.managed.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * ManagementObject annotation for describing ManagedObjects.
 * {@linkplain ManagedObject}
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81571 $
 */
@Inherited
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface ManagementObject
{
   /** The name used for ManagementObjectRef resolution. Generally
    * this is taken from a property annotated with
    * {@linkplain ManagementObjectID}.
    */
   String name() default ManagementConstants.GENERATED;
   /**
    * A description for the managed object. 
    */
   String description() default ManagementConstants.GENERATED;
   /** The name type used for ManagementObjectRef resolution. Generally
    * this is taken from a property annotated with
    * {@linkplain ManagementObjectID}.
    */
   String type() default AnnotationDefaults.EMPTY_STRING;
   /** The metadata attachment name for the ManagedObject */
   String attachmentName() default AnnotationDefaults.EMPTY_STRING;
   /** Is this a runtime extension of another ManagedObject. This
    * is used to tie together
    */
   boolean isRuntime() default false;

   /** The component type for MCs that are ManagedComponents */
   ManagementComponent componentType() default @ManagementComponent(type="", subtype="");

   /** What properties to include */
   ManagementProperties properties() default ManagementProperties.ALL;

   /**
    * A class level specification of the management properties. Depending on the
    * properties() value, this can either override or augment the ManagementProperty
    * annotations found on the bean fields/methods.
    * @return
    */
   ManagementProperty[] classProperties() default {};

   /** The exposed operations. If empty the operations will be obtained from
    * the annotated bean in a bean type specific way.
    */
   ManagementOperation[] operations() default {};

/*
   // The class to use for the ManagedProperty implementation
   Class<? extends ManagedProperty> propertyFactory() default NULL_PROPERTY_FACTORY.class;
   // The class to use for the ManagedProperty Fields implementation
   Class<? extends Fields> fieldsFactory() default NULL_FIELDS_FACTORY.class;
   // The constraints, allowed values populator factory
   Class<? extends ManagedPropertyConstraintsPopulatorFactory> constraintsFactory()
      default NULL_CONSTRAINTS.class;
*/
}
