/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.api;

import java.util.Map;

import org.jboss.managed.api.ManagedProperty;

/**
 * The exportable information for a DeploymentTemplate.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 85283 $
 */
public interface DeploymentTemplateInfo
{
   /**
    * The name of the DeploymentTemplate this info corresponds to
    * @return name of the deployment template
    */
   public String getName();
   /**
    * Information about the deployment template
    * @return Information about the deployment template
    */
   public String getDescription();

   /**
    * The name of the ManagedProperty in the Map<String, ManagedObject> map
    * obtained from the mainDeployer.getManagedObjects(VFSDeployment)
    * for the DeploymentTemplate this info is associated with.
    */
   public String getRootManagedPropertyName();

   /**
    * Get the template properties.
    * @return A name to property mapping of the properties that can be set
    * for use by the deployment template.
    */
   public Map<String, ManagedProperty> getProperties();

   /**
    * Create a deep copy of the template info. This ensures any ManagedProperty
    * objects returned in the copy do not share the same value references such
    * that modification of the property value in the copy affects the original.
    * @return a deep copy of the template info.
    */
   public DeploymentTemplateInfo copy();
}
