/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.mc.servlet.vdf.api;

import java.util.UUID;

import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.StatelessKernelController;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/**
 * MC based inject.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class MicrocontainerInject
{
   private KernelController controller;

   public MicrocontainerInject(KernelController controller)
   {
      if (controller == null)
         throw new IllegalArgumentException("Null controller");
      this.controller = controller;
   }

   /**
    * Do MC inject.
    *
    * @param instance the instance to inspewct for MC injections
    */
   public void inject(Object instance)
   {
      if (instance == null)
         return;

      String name = UUID.randomUUID().toString();
      BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder(name, instance.getClass().getName());
      builder.ignoreCreate();
      builder.ignoreStart();
      StatelessKernelController wrapper = new StatelessKernelController(controller);
      try
      {
         KernelControllerContext context = wrapper.install(builder.getBeanMetaData(), instance);
         if (ControllerState.INSTALLED.equals(context.getState()) == false)
         {
            //noinspection ThrowableResultOfMethodCallIgnored
            throw new IllegalArgumentException(
                  "Instance [" + instance + "] not fully installed, missing dependency? - " +
                  context.getDependencyInfo().getUnresolvedDependencies(null),
                  context.getError()
            );
         }
      }
      catch (IllegalArgumentException t)
      {
         throw t;
      }
      catch (Throwable t)
      {
         throw new RuntimeException(t);
      }
   }
}
