/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.mc.servlet.vdf.api;

import javax.servlet.ServletContext;

import org.jboss.kernel.Kernel;
import org.jboss.mc.common.ThreadLocalUtils;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/**
 * Initialize ThreadLocalUtils from ServletContext.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class VDFThreadLocalUtils
{
   /**
    * Initialize thread local.
    *
    * @param context the context
    */
   public static void init(ServletContext context)
   {
      KernelVDFConnector kvc = new KernelVDFConnector(context);
      if (kvc.isValid() == false)
         throw new IllegalArgumentException("No such VDF Kernel available: " + context);

      Kernel kernel = kvc.getUtility();
      ThreadLocalUtils.putKernel(kernel);

      VFSDeploymentUnitVDFConnector dvc = new VFSDeploymentUnitVDFConnector(context);
      if (dvc.isValid() == false)
         throw new IllegalArgumentException("No such VDF unit: " + context);

      DeploymentUnit unit = dvc.getUtility();
      ThreadLocalUtils.putUnit(unit);
   }

   /**
    * Reset.
    */
   public static void reset()
   {
      ThreadLocalUtils.removeKernel();
      ThreadLocalUtils.removeUnit();
   }
}
