/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mc.servlet.vdf.api;

import java.util.UUID;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.StatelessKernelController;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

public class MicrocontainerInject {
    private KernelController controller;

    public MicrocontainerInject(KernelController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
    }

    public void inject(Object instance) {
        if (instance == null) {
            return;
        }
        String name = UUID.randomUUID().toString();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)instance.getClass().getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        StatelessKernelController wrapper = new StatelessKernelController(this.controller);
        try {
            KernelControllerContext context = wrapper.install(builder.getBeanMetaData(), instance);
            if (!ControllerState.INSTALLED.equals((Object)context.getState())) {
                throw new IllegalArgumentException("Instance [" + instance + "] not fully installed, missing dependency? - " + context.getDependencyInfo().getUnresolvedDependencies(null), context.getError());
            }
        }
        catch (IllegalArgumentException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

