/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.filter;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredDelegateLoader
extends DelegateLoader {
    private static final Logger log = Logger.getLogger(FilteredDelegateLoader.class);
    private ClassFilter filter;

    public FilteredDelegateLoader(ClassLoaderPolicy delegate) {
        this(delegate, ClassFilter.EVERYTHING);
    }

    public FilteredDelegateLoader(ClassLoaderPolicy delegate, ClassFilter filter) {
        super(delegate);
        if (filter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.filter = filter;
    }

    public ClassFilter getFilter() {
        return this.filter;
    }

    @Override
    public Class<?> loadClass(String className) {
        boolean trace = log.isTraceEnabled();
        if (this.filter.matchesClassName(className)) {
            if (trace) {
                log.trace((Object)(this + " " + className + " matches class filter=" + this.filter));
            }
            return super.loadClass(className);
        }
        if (trace) {
            log.trace((Object)(this + " " + className + " does NOT match class filter=" + this.filter));
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        boolean trace = log.isTraceEnabled();
        if (this.filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches resource filter=" + this.filter));
            }
            return super.getResource(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match resource filter=" + this.filter));
        }
        return null;
    }

    @Override
    public void getResources(String name, Set<URL> urls) throws IOException {
        boolean trace = log.isTraceEnabled();
        if (this.filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches filter=" + this.filter));
            }
            super.getResources(name, urls);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match filter=" + this.filter));
        }
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        builder.append(" filter=").append(this.getFilter());
    }
}

