/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectName;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.PackageInformation;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.base.BaseClassLoaderMBean;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.ClassLoaderManager;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.logging.Logger;
import org.jboss.util.collection.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClassLoader
extends SecureClassLoader
implements BaseClassLoaderMBean,
RealClassLoader {
    private static final Logger log = Logger.getLogger(BaseClassLoader.class);
    private ReentrantLock lock = new ReentrantLock(true);
    private ClassLoaderPolicy policy;
    private DelegateLoader loader;
    private Map<String, URL> resourceCache;
    private Set<String> blackList;

    public BaseClassLoader(ClassLoaderPolicy policy) {
        super(null);
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        this.policy = policy;
        ClassLoaderPolicy basePolicy = policy;
        basePolicy.setClassLoader(this);
        this.loader = new DelegateLoader(policy);
        if (((BaseClassLoaderPolicy)basePolicy).isCachable()) {
            this.resourceCache = new ConcurrentHashMap<String, URL>();
        }
        if (((BaseClassLoaderPolicy)basePolicy).isBlackListable()) {
            this.blackList = new CopyOnWriteArraySet<String>();
        }
        log.debug((Object)("Created " + this + " with policy " + policy.toLongString()));
    }

    public ObjectName getObjectName() {
        return this.policy.getObjectName();
    }

    ClassLoaderPolicy getPolicy() {
        return this.policy;
    }

    DelegateLoader getLoader() {
        return this.loader;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " loadClass " + name + " resolve=" + resolve));
        }
        ClassLoaderUtils.checkClassName(name);
        Class<?> result = this.findLoadedClass(name);
        if (result != null && trace) {
            log.trace((Object)(this + " already loaded class " + name + " " + ClassLoaderUtils.classToString(result)));
        }
        if (name.charAt(0) == '[') {
            if (trace) {
                log.trace((Object)(this + " resolving array class " + name + " using Class.forName()"));
            }
            result = Class.forName(name, true, this);
            if (trace) {
                log.trace((Object)(this + " resolved array " + ClassLoaderUtils.classToString(result)));
            }
        }
        if (result == null) {
            result = this.loadClassFromDomain(name, trace);
        }
        if (result == null) {
            if (trace) {
                log.trace((Object)(this + " class not found " + name));
            }
            throw new ClassNotFoundException(name + " from " + this.toLongString());
        }
        if (resolve) {
            if (trace) {
                log.trace((Object)(this + " resolveClass " + ClassLoaderUtils.classToString(result)));
            }
            this.resolveClass(result);
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        ClassLoaderPolicy basePolicy = this.policy;
        BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " getResource " + name + " domain=" + domain));
        }
        if (domain != null) {
            return domain.getResource(this, name);
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ClassLoaderPolicy basePolicy = this.policy;
        BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " findResources " + name + " domain=" + domain));
        }
        HashSet<URL> resourceURLs = new HashSet<URL>();
        if (domain != null) {
            domain.getResources(this, name, resourceURLs);
        }
        return Iterators.toEnumeration(resourceURLs.iterator());
    }

    Class<?> loadClassLocally(String name) {
        return this.loadClassLocally(name, log.isTraceEnabled());
    }

    synchronized Class<?> loadClassLocally(final String name, final boolean trace) {
        Class<?> result;
        if (trace) {
            log.trace((Object)(this + " load class locally " + name));
        }
        if ((result = this.findLoadedClass(name)) != null) {
            if (trace) {
                log.trace((Object)(this + " already loaded " + ClassLoaderUtils.classToString(result)));
            }
            return result;
        }
        final String resourcePath = ClassLoaderUtils.classNameToPath(name);
        return AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class<?> run() {
                InputStream is = BaseClassLoader.this.policy.getResourceAsStream(resourcePath);
                if (is == null) {
                    if (trace) {
                        log.trace((Object)(this + " resource not found locally " + resourcePath + " for " + name));
                    }
                    return null;
                }
                byte[] byteCode = ClassLoaderUtils.loadByteCode(name, is);
                ClassLoaderPolicy basePolicy = BaseClassLoader.this.policy;
                ProtectionDomain protectionDomain = ((BaseClassLoaderPolicy)basePolicy).getProtectionDomain(name, resourcePath);
                try {
                    byte[] transformed = BaseClassLoader.this.policy.transform(name, byteCode, protectionDomain);
                    if (transformed != null) {
                        byteCode = transformed;
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unexpected error transforming class " + name, t);
                }
                BaseClassLoader.this.definePackage(name);
                Class result = protectionDomain != null ? BaseClassLoader.this.defineClass(name, byteCode, 0, byteCode.length, protectionDomain) : BaseClassLoader.this.defineClass(name, byteCode, 0, byteCode.length);
                if (trace) {
                    log.trace((Object)(this + " loaded class locally " + ClassLoaderUtils.classToString(result)));
                }
                return result;
            }
        }, this.policy.getAccessControlContext());
    }

    public URL getResourceLocally(String name) {
        return this.getResourceLocally(name, log.isTraceEnabled());
    }

    URL getResourceLocally(final String name, final boolean trace) {
        URL url;
        if (trace) {
            log.trace((Object)(this + " get resource locally " + name));
        }
        if (this.resourceCache != null && (url = this.resourceCache.get(name)) != null) {
            if (trace) {
                log.trace((Object)(this + " got resource from cache " + name));
            }
            return url;
        }
        if (this.blackList != null && this.blackList.contains(name)) {
            if (trace) {
                log.trace((Object)(this + " resource is blacklisted " + name));
            }
            return null;
        }
        URL result = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                URL result = BaseClassLoader.this.policy.getResource(name);
                if (result == null) {
                    if (trace) {
                        log.trace((Object)(this + " resource not found locally " + name));
                    }
                    return null;
                }
                if (trace) {
                    log.trace((Object)(this + " got resource locally " + name));
                }
                return result;
            }
        }, this.policy.getAccessControlContext());
        if (this.resourceCache != null && result != null) {
            this.resourceCache.put(name, result);
        }
        if (this.blackList != null && result == null) {
            this.blackList.add(name);
        }
        return result;
    }

    void getResourcesLocally(String name, Set<URL> urls) throws IOException {
        this.getResourcesLocally(name, urls, log.isTraceEnabled());
    }

    void getResourcesLocally(final String name, final Set<URL> urls, boolean trace) throws IOException {
        if (trace) {
            log.trace((Object)(this + " get resources locally " + name));
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    BaseClassLoader.this.policy.getResources(name, urls);
                    return null;
                }
            }, this.policy.getAccessControlContext());
        }
        catch (PrivilegedActionException e) {
            Exception e1 = e.getException();
            if (e1 instanceof RuntimeException) {
                throw (RuntimeException)e1;
            }
            if (e1 instanceof IOException) {
                throw (IOException)e1;
            }
            IOException e2 = new IOException("Unexpected error");
            e2.initCause(e1);
            throw e2;
        }
    }

    protected void definePackage(String className) {
        String packageName = ClassLoaderUtils.getClassPackageName(className);
        if (packageName.length() == 0) {
            return;
        }
        Package pkge = this.getPackage(packageName);
        if (pkge != null) {
            return;
        }
        PackageInformation pi = this.policy.getPackageInformation(packageName);
        try {
            if (pi != null) {
                this.definePackage(packageName, pi.specTitle, pi.specVersion, pi.specVendor, pi.implTitle, pi.implVersion, pi.implVendor, pi.sealBase);
            } else {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
        }
        catch (IllegalArgumentException alreadyDone) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClassFromDomain(String name, boolean trace) throws ClassNotFoundException {
        this.acquireLockFairly(trace);
        try {
            ClassLoaderPolicy basePolicy = this.policy;
            BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
            if (trace) {
                log.trace((Object)(this + " load from domain " + name + " domain=" + domain));
            }
            if (domain == null) {
                Class<?> result = this.loadClassLocally(name, trace);
                if (result == null) {
                    throw new IllegalStateException(this + " classLoader is not connected to a domain (probably undeployed?) for class " + name);
                }
                Class<?> clazz = result;
                return clazz;
            }
            Class<?> result = domain.loadClass(this, name);
            if (result != null && trace) {
                log.trace((Object)(this + " got class from domain " + ClassLoaderUtils.classToString(result)));
            }
            Class<?> clazz = result;
            return clazz;
        }
        finally {
            this.unlock(trace);
        }
    }

    public boolean isValid() {
        ClassLoaderPolicy basePolicy = this.policy;
        return basePolicy.getClassLoader() != null;
    }

    public Class<?> getCachedClass(String name) {
        return null;
    }

    public URL getCachedResource(String name) {
        return null;
    }

    public void clearBlackList(String name) {
        if (this.blackList != null) {
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)(this + " removing from blacklist " + name));
            }
            this.blackList.remove(name);
            this.policy.clearBlackList(name);
        }
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        builder.append('{').append(this.getPolicy().toLongString());
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void shutdownClassLoader() {
        log.debug((Object)(this.toLongString() + " shutdown!"));
        if (this.resourceCache != null) {
            this.resourceCache.clear();
        }
        if (this.blackList != null) {
            this.blackList.clear();
        }
    }

    protected void toLongString(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    boolean attemptLock() {
        return this.attemptLock(log.isTraceEnabled());
    }

    void lock() {
        this.acquireLockFairly(log.isTraceEnabled());
    }

    void unlock() {
        this.unlock(log.isTraceEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptLock(boolean trace) {
        Thread thread = Thread.currentThread();
        if (trace) {
            log.trace((Object)(this + " attemptLock " + thread));
        }
        boolean interrupted = Thread.interrupted();
        boolean result = false;
        try {
            result = this.lock.tryLock(0L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException ignored) {
        }
        finally {
            if (interrupted) {
                thread.interrupt();
            }
        }
        if (trace) {
            if (result) {
                log.trace((Object)(this + " locked " + thread + " holding=" + this.lock.getHoldCount()));
            } else {
                log.trace((Object)(this + " did NOT get the lock " + thread));
            }
        }
        if (result && this.lock.getHoldCount() == 1) {
            ClassLoaderManager.registerLoaderThread(this, thread);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLockFairly(boolean trace) {
        Thread thread = Thread.currentThread();
        if (trace) {
            log.trace((Object)(this + " aquireLockFairly " + thread));
        }
        boolean interrupted = Thread.interrupted();
        int waits = 0;
        try {
            while (true) {
                try {
                    while (!this.lock.tryLock(0L, TimeUnit.MICROSECONDS)) {
                        if (waits++ == 12) {
                            throw new IllegalStateException("Waiting too long to get the classloader lock: " + this);
                        }
                        if (trace) {
                            log.trace((Object)(this + " waiting for lock " + thread));
                        }
                        this.wait(10000L);
                    }
                    if (trace) {
                        log.trace((Object)(this + " aquiredLock " + thread + " holding=" + this.lock.getHoldCount()));
                    }
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                thread.interrupt();
            }
        }
        if (this.lock.getHoldCount() == 1) {
            ClassLoaderManager.registerLoaderThread(this, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(boolean trace) {
        Thread thread = Thread.currentThread();
        if (trace) {
            log.trace((Object)(this + " unlock " + thread + " holding=" + this.lock.getHoldCount()));
        }
        this.lock.unlock();
        if (this.lock.getHoldCount() == 0) {
            ClassLoaderManager.unregisterLoaderThread(this, thread);
        }
        BaseClassLoader baseClassLoader = this;
        synchronized (baseClassLoader) {
            this.notifyAll();
        }
    }
}

