/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCallbackItem<T>
extends JBossObject
implements CallbackItem<T> {
    protected T name;
    protected ControllerState whenRequired = ControllerState.CONFIGURED;
    protected ControllerState dependentState = ControllerState.INSTALLED;
    protected String attributeName;

    protected AbstractCallbackItem(T name) {
        this.name = name;
    }

    protected AbstractCallbackItem(T name, ControllerState whenRequired, ControllerState dependentState, String attributeName) {
        this.name = name;
        if (whenRequired != null) {
            this.whenRequired = whenRequired;
        }
        if (dependentState != null) {
            this.dependentState = dependentState;
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name!");
        }
        this.attributeName = attributeName;
    }

    @Override
    public void ownerCallback(Controller controller, boolean isInstallPhase) throws Throwable {
        this.log.info((Object)"Owner callback not implemented.");
    }

    protected void changeCallback(ControllerContext context, boolean isInstallPhase) throws Throwable {
    }

    @Override
    public void changeCallback(Controller controller, ControllerContext context, boolean isInstallPhase) throws Throwable {
        this.changeCallback(context, isInstallPhase);
    }

    @Override
    public T getIDependOn() {
        return this.name;
    }

    @Override
    public ControllerState getWhenRequired() {
        return this.whenRequired;
    }

    @Override
    public ControllerState getDependentState() {
        return this.dependentState;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" whenRequired=").append((Object)this.whenRequired);
        buffer.append(" dependentState=").append((Object)this.dependentState);
        buffer.append(" attributeName=").append(this.attributeName);
    }
}

