/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.deployers.spi.deployer.helpers;

import org.jboss.deployers.structure.spi.DeploymentContext;

/**
 * AbstractTopLevelClassLoaderDeployer.
 *
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public abstract class AbstractTopLevelClassLoaderDeployer extends AbstractClassLoaderDeployer
{
   public ClassLoader createClassLoader(DeploymentContext context) throws Exception
   {
      if (context.isTopLevel())
         return createTopLevelClassLoader(context);
      
      return context.getTopLevel().getClassLoader();
   }

   @Override
   public void removeClassLoader(DeploymentContext context) throws Exception
   {
      if (context.isTopLevel())
         removeTopLevelClassLoader(context);
   }

   /**
    * Create a top level classloader
    * 
    * @param context the context
    * @return the classloader
    * @throws Exception for any error
    */
   protected abstract ClassLoader createTopLevelClassLoader(DeploymentContext context) throws Exception;

   /**
    * Remove a top level classloader
    * 
    * @param context the context
    * @throws Exception for any error
    */
   protected void removeTopLevelClassLoader(DeploymentContext context) throws Exception
   {
   }
}
