/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.version.test;

import junit.framework.Test;
import org.jboss.deployers.structure.spi.classloading.Version;
import org.jboss.deployers.structure.spi.classloading.helpers.VersionImpl;
import org.jboss.test.deployers.structure.version.support.DummyVersion;
import org.jboss.test.deployers.structure.version.support.ZeroVersion;
import org.jboss.test.deployers.structure.version.test.AbstractVersionTest;

public class VersionComparatorTestCase
extends AbstractVersionTest {
    public VersionComparatorTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return VersionComparatorTestCase.suite(VersionComparatorTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSameImpl() throws Exception {
        this.registerVersionComparators();
        try {
            VersionImpl vi1 = VersionImpl.parseVersion((String)"1.2.3");
            VersionImpl vi2 = VersionImpl.parseVersion((String)"2.0.0.GA");
            this.assertLess((Version)vi1, (Version)vi2);
            this.assertGreater((Version)vi2, (Version)vi1);
            this.assertEquals((Version)vi2, (Version)new VersionImpl(2, 0, 0, "GA"));
            DummyVersion dv1 = new DummyVersion(1);
            DummyVersion dv2 = new DummyVersion(2);
            DummyVersion dv3 = new DummyVersion(2);
            this.assertLess(dv1, dv2);
            this.assertGreater(dv2, dv1);
            this.assertEquals(dv2, dv3);
        }
        finally {
            this.clearVersionComparators();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDifferentImpl() throws Exception {
        this.registerVersionComparators();
        try {
            VersionImpl vi1 = VersionImpl.parseVersion((String)"1.2.3");
            VersionImpl vi2 = VersionImpl.parseVersion((String)"2.0.0.GA");
            DummyVersion dv1 = new DummyVersion(1);
            DummyVersion dv2 = new DummyVersion(2);
            this.assertLess(dv1, (Version)vi2);
            this.assertLess((Version)vi1, dv2);
            this.assertGreater((Version)vi2, dv1);
            this.assertGreater(dv2, (Version)vi1);
            this.assertEquals((Version)vi2, dv2);
            this.assertEquals(dv2, (Version)vi2);
        }
        finally {
            this.clearVersionComparators();
        }
    }

    public void testFailure() throws Exception {
        ZeroVersion z1 = new ZeroVersion();
        this.assertFailVersion(z1, Version.DEFAULT_VERSION);
        this.assertFailVersion(z1, new DummyVersion(0));
        this.assertFailVersion(Version.DEFAULT_VERSION, z1);
        this.assertFailVersion(new DummyVersion(0), z1);
    }
}

