/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.classloading;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.structure.spi.classloading.Version;
import org.jboss.deployers.structure.spi.classloading.VersionComparator;
import org.jboss.deployers.structure.spi.classloading.helpers.VersionImpl;
import org.jboss.deployers.structure.spi.classloading.helpers.VersionImplComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionComparatorRegistry {
    private static VersionComparatorRegistry registry = new VersionComparatorRegistry();
    private Map<Class<? extends Version>, Map<Class<? extends Version>, VersionComparator>> comparatorMap = new ConcurrentHashMap<Class<? extends Version>, Map<Class<? extends Version>, VersionComparator>>();

    private VersionComparatorRegistry() {
        this.registerVersionComparator(VersionImpl.class, new VersionImplComparator());
    }

    public static VersionComparatorRegistry getInstance() {
        return registry;
    }

    public <T extends Version, U extends Version> void removeVersionComparator(Class<T> t, Class<U> u) {
        this.registerVersionComparator(t, u, null);
    }

    public <T extends Version> void removeVersionComparator(Class<T> t) {
        this.registerVersionComparator(t, null);
    }

    public <T extends Version> void registerVersionComparator(Class<T> t, VersionComparator<T, T> comparator) {
        this.registerVersionComparator(t, t, comparator);
    }

    public <T extends Version, U extends Version> void registerVersionComparator(Class<T> t, Class<U> u, VersionComparator<T, U> comparator) {
        if (t == null || u == null) {
            throw new IllegalArgumentException("Null version class");
        }
        if (comparator == null) {
            Map<Class<? extends Version>, VersionComparator> uKeyMap;
            Map<Class<? extends Version>, VersionComparator> tKeyMap = this.comparatorMap.get(t);
            if (tKeyMap != null) {
                tKeyMap.remove(u);
            }
            if (!t.equals(u) && (uKeyMap = this.comparatorMap.get(u)) != null) {
                uKeyMap.remove(t);
            }
        } else {
            Map<Class<? extends Version>, VersionComparator> tKeyMap = this.comparatorMap.get(t);
            if (tKeyMap == null) {
                tKeyMap = new HashMap<Class<? extends Version>, VersionComparator>();
                this.comparatorMap.put(t, tKeyMap);
            }
            tKeyMap.put(u, comparator);
            if (!t.equals(u)) {
                Map<Class<? extends Version>, VersionComparator> uKeyMap = this.comparatorMap.get(u);
                if (uKeyMap == null) {
                    uKeyMap = new HashMap<Class<? extends Version>, VersionComparator>();
                    this.comparatorMap.put(u, uKeyMap);
                }
                uKeyMap.put(t, new SwitchVersionComparator<U, T>(comparator));
            }
        }
    }

    protected <T extends Version, U extends Version> VersionComparator<T, U> getComparator(T t, U u) {
        return this.getComparator(t.getClass(), u.getClass());
    }

    public VersionComparator getComparator(Class<? extends Version> t, Class<? extends Version> u) {
        Map<Class<? extends Version>, VersionComparator> map = this.comparatorMap.get(t);
        if (map == null) {
            return null;
        }
        return map.get(u);
    }

    public <T extends Version, U extends Version> int compare(T t, U u) {
        VersionComparator<T, U> comparator = this.getComparator(t, u);
        if (comparator == null) {
            throw new IllegalArgumentException("Missing version comparator for Version impl pair: (" + t.getClass().getName() + "," + u.getClass().getName() + ")");
        }
        return comparator.compare(t, u);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SwitchVersionComparator<T extends Version, U extends Version>
    implements VersionComparator<T, U> {
        private VersionComparator<U, T> delegate;

        public SwitchVersionComparator(VersionComparator<U, T> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("Null delegate");
            }
            this.delegate = delegate;
        }

        @Override
        public int compare(T t, U u) {
            return this.delegate.compare(u, t) * -1;
        }
    }
}

