/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.classloading.helpers;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jboss.deployers.structure.spi.classloading.Version;

public class VersionImpl
extends Version {
    private static final String SEPARATOR = ".";
    private static volatile Pattern QUALIFIER_PATTERN;
    private static final VersionImpl emptyVersion;
    private int major;
    private int minor;
    private int micro;
    private String qualifier;

    public VersionImpl(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public VersionImpl(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        if (qualifier == null) {
            qualifier = "";
        }
        this.qualifier = qualifier;
        this.validate();
    }

    private VersionImpl(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qualifier = st.nextToken();
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid format");
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid format");
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    protected void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("negative major: " + this.major);
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("negative minor: " + this.minor);
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("negative micro: " + this.micro);
        }
        if (QUALIFIER_PATTERN == null) {
            QUALIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9_-]*");
        }
        if (!QUALIFIER_PATTERN.matcher(this.qualifier).matches()) {
            throw new IllegalArgumentException("invalid qualifier: " + this.qualifier);
        }
    }

    public static VersionImpl parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new VersionImpl(version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major).append(SEPARATOR).append(this.minor).append(SEPARATOR).append(this.micro);
        if (this.qualifier.length() > 0) {
            builder.append(SEPARATOR).append(this.qualifier);
        }
        return builder.toString();
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VersionImpl)) {
            return false;
        }
        VersionImpl other = (VersionImpl)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.qualifier.equals(other.qualifier);
    }

    int compareTo(VersionImpl version) {
        if (version == this) {
            return 0;
        }
        int result = this.major - version.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - version.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - version.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(version.qualifier);
    }

    static {
        emptyVersion = new VersionImpl(0, 0, 0);
    }
}

