/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.helpers;

import java.io.IOException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.helpers.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.AbstractVirtualFileVisitor;

public class AbstractCandidateStructureVisitor
extends AbstractVirtualFileVisitor {
    private static final Logger log = Logger.getLogger(AbstractCandidateStructureVisitor.class);
    private final VirtualFile root;
    private final VirtualFile parent;
    private final StructureMetaData metaData;
    private final VFSStructuralDeployers deployers;
    private boolean ignoreDirectories;
    private VirtualFileFilter filter;

    public AbstractCandidateStructureVisitor(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers) {
        this(root, parent, metaData, deployers, null);
    }

    public AbstractCandidateStructureVisitor(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers, VisitorAttributes attributes) {
        super(attributes);
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.root = root;
        this.parent = parent;
        this.metaData = metaData;
        this.deployers = deployers;
    }

    public VirtualFile getParent() {
        return this.parent;
    }

    public boolean isIgnoreDirectories() {
        return this.ignoreDirectories;
    }

    public VirtualFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public void setIgnoreDirectories(boolean ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
    }

    public void visit(VirtualFile file) {
        String path = AbstractStructureDeployer.getRelativePath(this.parent, file);
        ContextInfo context = this.metaData.getContext(path);
        if (context == null) {
            try {
                if (this.ignoreDirectories && !SecurityActions.isLeaf(file)) {
                    return;
                }
            }
            catch (IOException e) {
                log.debug((Object)("Ignoring " + file + " reason=" + e));
                return;
            }
            if (this.filter != null && !this.filter.accepts(file)) {
                return;
            }
            try {
                this.deployers.determineStructure(this.root, this.parent, file, this.metaData);
            }
            catch (Exception e) {
                log.debug((Object)("Ignoring " + file + " reason=" + e));
                return;
            }
        }
    }
}

