/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployerWithOutput;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVFSParsingDeployer<T>
extends AbstractParsingDeployerWithOutput<T> {
    public AbstractVFSParsingDeployer(Class<T> output) {
        super(output);
    }

    protected boolean accepts(VFSDeploymentUnit unit) throws DeploymentException {
        return true;
    }

    protected boolean accepts(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            this.log.trace((Object)("Not a vfs deployment: " + unit.getName()));
            return false;
        }
        return this.accepts((VFSDeploymentUnit)unit);
    }

    protected T parse(DeploymentUnit unit, String name, T root) throws Exception {
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        VirtualFile file = vfsDeploymentUnit.getMetaDataFile(name);
        if (file == null) {
            return null;
        }
        T result = this.parse(vfsDeploymentUnit, file, root);
        if (result != null) {
            this.init(vfsDeploymentUnit, result, file);
        }
        return result;
    }

    protected T parse(DeploymentUnit unit, String name, String suffix, T root) throws Exception {
        VFSDeploymentUnit vfsDeploymentUnit;
        List<VirtualFile> files;
        if (name == null && this.isIncludeDeploymentFile()) {
            name = unit.getName();
        }
        if ((files = (vfsDeploymentUnit = (VFSDeploymentUnit)unit).getMetaDataFiles(name, suffix)).size() == 0) {
            return null;
        }
        if (files.size() > 1) {
            throw new DeploymentException("Only one file is allowed, found=" + files);
        }
        VirtualFile file = files.get(0);
        T result = this.parse(vfsDeploymentUnit, file, root);
        if (result != null) {
            this.init(vfsDeploymentUnit, result, file);
        }
        return result;
    }

    protected abstract T parse(VFSDeploymentUnit var1, VirtualFile var2, T var3) throws Exception;

    protected void init(VFSDeploymentUnit unit, T metaData, VirtualFile file) throws Exception {
    }
}

