/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.guice.spi;

import com.google.inject.Provider;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MicrocontainerProvider<T>
implements Provider<T> {
    private Class<T> type;
    private Object name;
    private Controller controller;

    protected MicrocontainerProvider(Class<T> type, Object name) {
        if (type == null) {
            throw new IllegalArgumentException("Null type.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        this.type = type;
        this.name = name;
    }

    void initialize(Controller controller) {
        this.controller = controller;
    }

    public T get() {
        if (this.controller == null) {
            throw new IllegalArgumentException("Null controller, missing initialization.");
        }
        ControllerContext context = this.controller.getInstalledContext(this.name);
        if (context != null) {
            Object target = context.getTarget();
            if (target instanceof BeanFactory) {
                try {
                    target = ((BeanFactory)target).createBean();
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            return this.type.cast(target);
        }
        return null;
    }
}

