/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.test.AbstractSystemTest;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.system.controller.ControllerTestDelegate;
import org.jboss.test.system.controller.NewControllerTestDelegate;
import org.jboss.test.system.controller.OldControllerTestDelegate;
import org.jboss.test.system.controller.PlainControllerTestDelegate;
import org.jboss.test.system.controller.support.Order;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControllerTest
extends AbstractSystemTest {
    public static boolean OLD_NOT_REGISTERED = false;
    public static boolean OLD_REGISTERED = true;

    public AbstractControllerTest(String name) {
        super(name);
    }

    public static AbstractTestDelegate getNewControllerDelegate(Class<?> clazz) throws Exception {
        NewControllerTestDelegate delegate = new NewControllerTestDelegate(clazz);
        return delegate;
    }

    public static AbstractTestDelegate getPlainControllerDelegate(Class<?> clazz) throws Exception {
        PlainControllerTestDelegate delegate = new PlainControllerTestDelegate(clazz);
        return delegate;
    }

    public static AbstractTestDelegate getOldControllerDelegate(Class<?> clazz) throws Exception {
        OldControllerTestDelegate delegate = new OldControllerTestDelegate(clazz);
        return delegate;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Order.reset();
    }

    protected void tearDown() throws Exception {
        this.getControllerDelegate().uninstallTemporary();
        super.tearDown();
    }

    protected ControllerTestDelegate getControllerDelegate() {
        return (ControllerTestDelegate)this.getDelegate();
    }

    protected MBeanServer getServer() {
        return this.getControllerDelegate().getServer();
    }

    protected ServiceControllerMBean getController() {
        return this.getControllerDelegate().getController();
    }

    protected List<ObjectName> deploy(URL url) throws Exception {
        return this.getControllerDelegate().deploy(url, true);
    }

    protected List<ObjectName> deploy(String resource) throws Exception {
        URL url = this.getResourceURL(resource);
        return this.deploy(url);
    }

    protected void undeploy(List<ObjectName> objectNames) {
        this.getControllerDelegate().undeploy(objectNames);
    }

    protected List<ObjectName> install(String resource) throws Exception {
        URL url = this.getResourceURL(resource);
        return this.install(url);
    }

    protected List<ObjectName> install(URL url) throws Exception {
        return this.getControllerDelegate().install(url);
    }

    protected void uninstall(List<ObjectName> objectNames) {
        this.getControllerDelegate().uninstall(objectNames);
    }

    protected void assertInstall(ObjectName name) throws Exception {
        String resource = this.getName();
        resource = resource.substring(4) + "_install.xml";
        this.install(resource);
        this.assertServiceConfigured(name);
        this.assertRegistered(name);
    }

    protected void assertUninstall(ObjectName name) throws Exception {
        this.uninstall(Collections.singletonList(name));
        this.assertNoService(name);
        this.assertNotRegistered(name);
    }

    protected List<ObjectName> assertDeploy(ObjectName name) throws Exception {
        String resource = this.getName();
        resource = resource.substring(4) + "_install.xml";
        List<ObjectName> result = this.deploy(resource);
        this.assertServiceRunning(name);
        this.assertRegistered(name);
        return result;
    }

    protected void assertUndeploy(ObjectName name) throws Exception {
        this.assertUndeploy(name, Collections.singletonList(name));
    }

    protected void assertUndeploy(ObjectName name, List<ObjectName> names) throws Exception {
        this.uninstall(names);
        this.assertNoService(name);
        this.assertNotRegistered(name);
    }

    protected void validate() throws Exception {
        this.getControllerDelegate().validate();
    }

    protected void assertInvalidDeployments() throws Exception {
        this.getControllerDelegate().assertInvalidDeployments();
    }

    protected void assertInitialDeployFailure(String resource, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        URL url = this.getResourceURL(resource);
        this.getControllerDelegate().assertInitialDeployFailure(url, name, expected);
    }

    protected List<ObjectName> assertDeployFailure(ObjectName name, Class<? extends Throwable> expected) throws Exception {
        return this.assertDeployFailure(name, 4, expected);
    }

    protected List<ObjectName> assertDeployFailure(ObjectName name, int expectedState, Class<? extends Throwable> expected) throws Exception {
        String resource = this.getName();
        resource = resource.substring(4) + "_bad.xml";
        return this.assertDeployFailure(resource, name, expectedState, expected);
    }

    protected List<ObjectName> assertDeployFailure(String resource, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        return this.assertDeployFailure(resource, name, 4, expected);
    }

    protected List<ObjectName> assertDeployFailure(String resource, ObjectName name, int expectedState, Class<? extends Throwable> expected) throws Exception {
        URL url = this.getResourceURL(resource);
        List<ObjectName> result = this.getControllerDelegate().assertDeployFailure(url, name, expected);
        if (expectedState == 4) {
            this.assertServiceFailed(name, OLD_REGISTERED);
        } else {
            this.assertServiceState(name, expectedState);
        }
        return result;
    }

    protected void redeployAfterDeployFailure(ObjectName name, Class<? extends Throwable> expected) throws Exception {
        String root = this.getName();
        root = root.substring(4);
        List<ObjectName> names = this.assertDeployFailure(root + "_bad.xml", SimpleMBean.OBJECT_NAME, expected);
        this.undeploy(names);
        this.deploy(root + "_good.xml");
        this.assertServiceRunning(name);
    }

    protected void redeployAfterUndeployFailure(ObjectName name) throws Exception {
        String root = this.getName();
        root = root.substring(4);
        List<ObjectName> names = this.deploy(root + "_bad.xml");
        this.assertServiceRunning(name);
        this.undeploy(names);
        this.deploy(root + "_good.xml");
        this.assertServiceRunning(name);
    }

    protected List<ObjectName> assertMaybeDeployFailure(ObjectName name, Class<? extends Throwable> expected) throws Exception {
        String resource = this.getName();
        resource = resource.substring(4) + "_bad.xml";
        return this.assertMaybeDeployFailure(resource, name, expected);
    }

    protected List<ObjectName> assertMaybeDeployFailure(String resource, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        URL url = this.getResourceURL(resource);
        List<ObjectName> result = this.getControllerDelegate().assertMaybeDeployFailure(url, name, expected);
        this.assertServiceFailed(name, OLD_NOT_REGISTERED);
        return result;
    }

    protected void redeployAfterMaybeDeployFailure(ObjectName name, Class<? extends Throwable> expected) throws Exception {
        String root = this.getName();
        root = root.substring(4);
        List<ObjectName> names = this.assertMaybeDeployFailure(root + "_bad.xml", SimpleMBean.OBJECT_NAME, expected);
        this.undeploy(names);
        this.deploy(root + "_good.xml");
        this.assertServiceRunning(name);
    }

    protected void assertMaybeParseFailure(ObjectName name, Class<? extends Throwable> expected) throws Exception {
        String resource = this.getName();
        resource = resource.substring(4) + "_bad.xml";
        this.assertMaybeParseFailure(resource, name, expected);
    }

    protected void assertMaybeParseFailure(String resource, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        URL url = this.getResourceURL(resource);
        this.getControllerDelegate().assertMaybeParseFailure(url, name, expected);
        this.assertServiceFailed(name, OLD_NOT_REGISTERED);
    }

    protected ServiceContext getServiceContext(ObjectName name) throws Exception {
        AbstractControllerTest.assertNotNull((Object)name);
        return this.getControllerDelegate().getServiceContext(name);
    }

    protected void assertServiceFailed(ObjectName name) throws Exception {
        this.assertServiceFailed(name, OLD_REGISTERED);
    }

    protected void assertServiceFailed(ObjectName name, boolean registered) throws Exception {
        this.getControllerDelegate().assertServiceFailed(name, registered);
    }

    protected void assertServiceInstalled(ObjectName name) throws Exception {
        this.assertServiceState(name, 0, true);
    }

    protected void assertServiceConfigured(ObjectName name) throws Exception {
        this.assertServiceState(name, 1, true);
    }

    protected void assertServiceCreated(ObjectName name) throws Exception {
        this.assertServiceState(name, 2, true);
    }

    protected void assertServiceRunning(ObjectName name) throws Exception {
        this.assertServiceState(name, 3, true);
    }

    protected void assertServiceStopped(ObjectName name) throws Exception {
        this.assertServiceState(name, 5, true);
    }

    protected void assertServiceDestroyed(ObjectName name) throws Exception {
        this.assertServiceState(name, 6, true);
    }

    protected void assertServiceState(ObjectName name, int expectedState) throws Exception {
        ServiceContext ctx = this.getServiceContext(name);
        AbstractControllerTest.assertTrue((String)("Incorrect state for " + name + " expected " + ServiceContext.getStateString((int)expectedState) + " got " + ctx.getStateString()), (expectedState == ctx.state ? 1 : 0) != 0);
    }

    protected void assertServiceState(ObjectName name, int expectedState, boolean registered) throws Exception {
        this.getControllerDelegate().assertServiceState(name, expectedState, registered);
    }

    protected void assertNoService(ObjectName name) throws Exception {
        ServiceContext ctx = this.getServiceContext(name);
        AbstractControllerTest.assertNull((String)("Should not be a service context for " + name), (Object)ctx);
    }

    protected URL getResourceURL(String resource) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url == null) {
            throw new IOException(resource + " not found");
        }
        return url;
    }

    protected void assertRegistered(ObjectName name) throws Exception {
        MBeanServer server = this.getServer();
        AbstractControllerTest.assertTrue((String)(name + " should be registered in the MBeanServer"), (boolean)server.isRegistered(name));
    }

    protected void assertNotRegistered(ObjectName name) throws Exception {
        MBeanServer server = this.getServer();
        AbstractControllerTest.assertFalse((String)(name + " should NOT be registered in the MBeanServer"), (boolean)server.isRegistered(name));
    }

    protected <T> T getMBean(Class<T> expected, ObjectName name, String attribute) throws Exception {
        MBeanServer server = this.getServer();
        Object object = server.getAttribute(name, attribute);
        AbstractControllerTest.assertNotNull((Object)object);
        return AbstractControllerTest.assertInstanceOf(expected, object);
    }

    protected Simple getSimple() throws Exception {
        return this.getMBean(Simple.class, SimpleMBean.OBJECT_NAME, "Instance");
    }

    protected void FAILS_IN_OLD() {
        this.getLog().debug((Object)"This test fails with the old service controller, ignoring.");
    }
}

