/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.AssertionFailedError;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.test.AbstractSystemTest;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.IncompleteDeploymentException;
import org.jboss.test.system.controller.SimpleSARDeployer;
import org.jboss.test.system.controller.support.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControllerTestDelegate
extends AbstractTestDelegate {
    private MBeanServer server;
    private ServiceControllerMBean serviceController;
    private SimpleSARDeployer deployer;

    public ControllerTestDelegate(Class<?> clazz) {
        super(clazz);
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public ServiceControllerMBean getController() {
        return this.serviceController;
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.setUpMBeanServerBuilder();
            this.server = this.createMBeanServer();
            this.serviceController = this.createServiceController();
            this.server.registerMBean(this.serviceController, ServiceControllerMBean.OBJECT_NAME);
            this.deployer = new SimpleSARDeployer(this.server, this.serviceController);
            Order.reset();
            this.deploy();
            if (this.isValidateAtSetUp()) {
                this.validate();
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)"Error in setup", (Throwable)e);
            throw e;
        }
    }

    protected void setUpMBeanServerBuilder() {
        System.setProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
    }

    protected boolean isValidateAtSetUp() {
        return true;
    }

    protected MBeanServer createMBeanServer() {
        return MBeanServerFactory.newMBeanServer("jboss");
    }

    public abstract ServiceControllerMBean createServiceController() throws Exception;

    public void tearDown() throws Exception {
        this.deployer.uninstall();
        super.tearDown();
    }

    protected void uninstallTemporary() throws Exception {
        this.deployer.uninstallTemporary();
    }

    protected void validate() throws Exception {
        HashSet waitingForClasses = new HashSet();
        List waitingForDepends = this.serviceController.listIncompletelyDeployed();
        List allServices = this.serviceController.listDeployed();
        HashSet rootCause = new HashSet(waitingForDepends);
        HashSet<ServiceContext> missing = new HashSet<ServiceContext>();
        Iterator i = rootCause.iterator();
        block0: while (i.hasNext()) {
            ServiceContext ctx = (ServiceContext)i.next();
            for (ServiceContext dependee : ctx.iDependOn) {
                if (dependee.state == 3) continue;
                if (!allServices.contains(dependee)) {
                    missing.add(dependee);
                }
                i.remove();
                continue block0;
            }
        }
        rootCause.addAll(missing);
        IncompleteDeploymentException ide = new IncompleteDeploymentException(waitingForClasses, waitingForDepends, rootCause, Collections.emptyList(), Collections.emptyList());
        if (!ide.isEmpty()) {
            throw ide;
        }
    }

    protected void deploy() throws Exception {
        String testName = this.clazz.getName();
        int index = (testName = testName.replace('.', '/')).indexOf("NewUnitTestCase");
        if (index != -1) {
            testName = testName.substring(0, index);
        }
        if ((index = testName.indexOf("OldUnitTestCase")) != -1) {
            testName = testName.substring(0, index);
        }
        if ((index = testName.indexOf("PlainUnitTestCase")) != -1) {
            testName = testName.substring(0, index);
        }
        testName = testName + ".xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            this.deploy(url, false);
        } else {
            this.log.debug((Object)("No test specific deployment " + testName));
        }
    }

    protected List<ObjectName> deploy(URL url, boolean temporary) throws Exception {
        return this.deployer.deploy(url, temporary);
    }

    protected void undeploy(List<ObjectName> objectNames) {
        this.deployer.undeploy(objectNames);
    }

    protected List<ObjectName> install(URL url) throws Exception {
        return this.deployer.install(url);
    }

    protected void uninstall(List<ObjectName> objectNames) {
        this.deployer.uninstall(objectNames);
    }

    public abstract void assertMBeanFailed(ObjectName var1, boolean var2) throws Exception;

    protected IncompleteDeploymentException assertInvalidDeployments() throws Exception {
        try {
            this.validate();
            throw new AssertionFailedError("Deployments should not be valid!");
        }
        catch (IncompleteDeploymentException expected) {
            this.log.debug((Object)("Got expected " + expected.getClass().getName()));
            return expected;
        }
    }

    protected void assertInitialDeployFailure(URL url, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        try {
            this.deploy(url, true);
            throw new AssertionFailedError("Should have got a " + expected.getName());
        }
        catch (Throwable t) {
            AbstractSystemTest.checkThrowableDeep(expected, t);
            if (name != null) {
                this.assertNoService(name);
            }
            return;
        }
    }

    public List<ObjectName> assertDeployFailure(URL url, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        List<ObjectName> result = this.deploy(url, true);
        IncompleteDeploymentException e = this.assertInvalidDeployments();
        this.checkIncomplete(e, name, expected);
        return result;
    }

    public List<ObjectName> assertMaybeDeployFailure(URL url, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        return this.assertDeployFailure(url, name, expected);
    }

    public void assertMaybeParseFailure(URL url, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        this.assertDeployFailure(url, name, expected);
        this.assertServiceFailed(name);
    }

    protected void checkIncomplete(IncompleteDeploymentException e, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        Collection incomplete = e.getMbeansWaitingForDepends();
        for (ServiceContext ctx : incomplete) {
            if (!name.equals(ctx.objectName)) continue;
            Throwable problem = ctx.getProblem();
            if (e != null || expected != null) {
                if (expected != null && problem == null) {
                    throw new AssertionFailedError("Did not get expected " + expected.getName() + " for " + ctx);
                }
                if (expected == null && problem != null) {
                    if (problem instanceof Exception) {
                        throw (Exception)problem;
                    }
                    if (problem instanceof Error) {
                        throw (Error)problem;
                    }
                    throw new UndeclaredThrowableException(problem);
                }
                if (expected != null) {
                    AbstractSystemTest.checkThrowableDeep(expected, problem);
                    if (4 != ctx.state) {
                        throw new AssertionFailedError("Context is not in the FAILED state: " + ctx);
                    }
                }
            }
            return;
        }
        throw new AssertionFailedError("Did not find " + name + " in incomplete deployments " + incomplete);
    }

    protected ServiceContext getServiceContext(ObjectName name) throws Exception {
        return this.getController().getServiceContext(name);
    }

    protected void assertNoService(ObjectName name) throws Exception {
        ServiceContext ctx = this.getServiceContext(name);
        if (ctx != null && ctx.state != 7) {
            throw new AssertionFailedError("Should not be a service context for " + ctx);
        }
    }

    protected void assertServiceFailed(ObjectName name) throws Exception {
        this.assertServiceFailed(name, AbstractControllerTest.OLD_REGISTERED);
    }

    protected void assertServiceFailed(ObjectName name, boolean registered) throws Exception {
        this.assertServiceState(name, 4, registered);
        this.assertMBeanFailed(name, registered);
    }

    protected void assertServiceState(ObjectName name, int expectedState, boolean registered) throws Exception {
        ServiceContext ctx = this.getServiceContext(name);
        if (!registered && ctx == null) {
            return;
        }
        if (ctx == null) {
            throw new AssertionFailedError("Incorrect state for " + name + " expected " + ServiceContext.getStateString((int)expectedState) + " but there is no context/state");
        }
        if (expectedState != ctx.state) {
            throw new AssertionFailedError("Incorrect state for " + name + " expected " + ServiceContext.getStateString((int)expectedState) + " got " + ctx.getStateString());
        }
    }
}

