/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.AssertionFailedError;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.test.AbstractSystemTest;
import org.jboss.test.system.controller.ControllerTestDelegate;
import org.jboss.test.system.controller.legacy.OldServiceController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldControllerTestDelegate
extends ControllerTestDelegate {
    public OldControllerTestDelegate(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public ServiceControllerMBean createServiceController() {
        return new OldServiceController();
    }

    @Override
    public void assertMBeanFailed(ObjectName name, boolean registered) throws Exception {
        MBeanServer server = this.getServer();
        if (!registered && server.isRegistered(name)) {
            throw new AssertionFailedError(name + " should not be registered after a failure");
        }
        if (registered && !server.isRegistered(name)) {
            throw new AssertionFailedError(name + " should be registered after a failure");
        }
    }

    @Override
    public List<ObjectName> assertMaybeDeployFailure(URL url, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        if (expected != null) {
            try {
                this.deploy(url, true);
                throw new AssertionFailedError("Should have got a " + expected.getName());
            }
            catch (Throwable throwable) {
                AbstractSystemTest.checkThrowableDeep(expected, throwable);
                return Collections.emptyList();
            }
        }
        return super.assertMaybeDeployFailure(url, name, expected);
    }

    @Override
    public void assertMaybeParseFailure(URL url, ObjectName name, Class<? extends Throwable> expected) throws Exception {
        this.assertInitialDeployFailure(url, name, expected);
    }
}

