/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.test.system.controller.TestClassLoader;
import org.jboss.test.system.controller.legacy.DeploymentException;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSARDeployer {
    private static Logger log = Logger.getLogger(SimpleSARDeployer.class);
    public static ObjectName classLoaderObjectName = ObjectNameFactory.create((String)"test:classloader=test");
    private ServiceControllerMBean serviceController;
    private List<ObjectName> deployed = new CopyOnWriteArrayList<ObjectName>();
    private List<ObjectName> tempDeployed = new CopyOnWriteArrayList<ObjectName>();
    private DocumentBuilder parser;

    public SimpleSARDeployer(MBeanServer server, ServiceControllerMBean serviceController) throws Exception {
        this.serviceController = serviceController;
        TestClassLoader classLoader = new TestClassLoader();
        server.registerMBean(classLoader, classLoaderObjectName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.parser = factory.newDocumentBuilder();
    }

    public List<ObjectName> deploy(URL url, boolean temporary) throws Exception {
        long start = System.currentTimeMillis();
        List<ObjectName> result = this.doInstall(url, temporary);
        try {
            this.create(result);
            try {
                this.start(result);
            }
            catch (Throwable t) {
                this.stop(result);
                throw t;
            }
        }
        catch (Throwable t) {
            this.destroy(result);
            this.remove(result);
            throw DeploymentException.rethrowAsDeploymentException("Error", t);
        }
        log.debug((Object)("Deployed " + url + " took " + (System.currentTimeMillis() - start) + "ms"));
        return result;
    }

    public void uninstall() {
        this.undeploy(this.deployed);
    }

    public void uninstallTemporary() {
        this.undeploy(this.tempDeployed);
    }

    public void undeploy(List<ObjectName> objectNames) {
        this.stop(objectNames);
        this.destroy(objectNames);
        this.remove(objectNames);
    }

    public void create(List<ObjectName> services) throws Exception {
        for (ObjectName name : services) {
            this.serviceController.create(name);
        }
    }

    public void start(List<ObjectName> services) throws Exception {
        for (ObjectName name : services) {
            this.serviceController.start(name);
        }
    }

    public void stop(List<ObjectName> services) {
        ListIterator<ObjectName> i = services.listIterator(services.size());
        while (i.hasPrevious()) {
            ObjectName name = i.previous();
            try {
                this.serviceController.stop(name);
            }
            catch (Throwable ignored) {
                log.debug((Object)"Ignored", ignored);
            }
        }
    }

    public void destroy(List<ObjectName> services) {
        ListIterator<ObjectName> i = services.listIterator(services.size());
        while (i.hasPrevious()) {
            ObjectName name = i.previous();
            try {
                this.serviceController.destroy(name);
            }
            catch (Throwable ignored) {
                log.debug((Object)"Ignored", ignored);
            }
        }
    }

    public void remove(List<ObjectName> services) {
        for (ObjectName name : services) {
            this.deployed.remove(name);
            this.tempDeployed.remove(name);
            try {
                this.serviceController.remove(name);
            }
            catch (Throwable ignored) {
                log.debug((Object)"Ignored", ignored);
            }
        }
    }

    public List<ObjectName> install(URL url) throws Exception {
        long start = System.currentTimeMillis();
        List<ObjectName> result = this.doInstall(url, true);
        log.debug((Object)("Deployed " + url + " took " + (System.currentTimeMillis() - start) + "ms"));
        return result;
    }

    public void uninstall(List<ObjectName> services) {
        this.remove(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ObjectName> doInstall(URL url, boolean temporary) throws Exception {
        List result = null;
        Element element = null;
        try {
            InputStream stream = url.openStream();
            try {
                InputSource is = new InputSource(stream);
                is.setSystemId(url.toString());
                this.parser.setEntityResolver((EntityResolver)new JBossEntityResolver());
                Document document = this.parser.parse(is);
                element = document.getDocumentElement();
            }
            finally {
                stream.close();
            }
            result = this.serviceController.install(element, classLoaderObjectName);
            this.deployed.addAll(result);
            if (temporary) {
                this.tempDeployed.addAll(result);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Error deploying: " + url + ": " + e));
            throw e;
        }
        return result;
    }
}

