/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.configure.attribute.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependsListAttributeTest
extends AbstractControllerTest {
    static ObjectName DEPENDS1 = ObjectNameFactory.create((String)"jboss.test:type=depends1");
    static ObjectName[] DEPENDSLIST1 = new ObjectName[]{DEPENDS1};
    static ObjectName DEPENDS2 = ObjectNameFactory.create((String)"jboss.test:type=depends2");
    static ObjectName[] DEPENDSLIST2 = new ObjectName[]{DEPENDS2};
    static ObjectName[] DEPENDSLIST = new ObjectName[]{DEPENDS1, DEPENDS2};

    public DependsListAttributeTest(String name) {
        super(name);
    }

    protected void assertEquals(ObjectName[] expected, Collection<ObjectName> actual) {
        List<ObjectName> expectedList = Arrays.asList(expected);
        DependsListAttributeTest.assertEquals(expectedList, actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependsListAttributeNone() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            DependsListAttributeTest.assertNull(simple.getObjectNamesAttribute1());
            DependsListAttributeTest.assertNull(simple.getObjectNamesAttribute2());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependsListAttributeOne() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(DEPENDSLIST1, simple.getObjectNamesAttribute1());
            DependsListAttributeTest.assertNull(simple.getObjectNamesAttribute2());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependsListAttributeTwo() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(DEPENDSLIST1, simple.getObjectNamesAttribute1());
            this.assertEquals(DEPENDSLIST2, simple.getObjectNamesAttribute2());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependsListAttributeMultiple() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(DEPENDSLIST, simple.getObjectNamesAttribute1());
            DependsListAttributeTest.assertNull(simple.getObjectNamesAttribute2());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependsListAttributeNested() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(DEPENDSLIST1, simple.getObjectNamesAttribute1());
            DependsListAttributeTest.assertNull(simple.getObjectNamesAttribute2());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    public void testDependsListAttributeNoValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testDependsListAttributeEmptyValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testDependsListAttributeInvalidValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testDependsListAttributeUnknownElement() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testDependsListAttributePatternValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testDependsListAttributeNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, RuntimeException.class);
    }

    public void testDependsListAttributeBrokenSetAttribute() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }
}

