/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.configure.value.depends.test;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ConfigurationException;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

public abstract class DependencyValueTest
extends AbstractControllerTest {
    static ObjectName DEPENDS = ObjectNameFactory.create((String)"jboss.test:type=depends");

    public DependencyValueTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependency() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            DependencyValueTest.assertEquals((Object)DEPENDS, (Object)simple.getObjectName());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependencyNested() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            DependencyValueTest.assertEquals((Object)DEPENDS, (Object)simple.getObjectName());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    public void testExplicitProxyType() throws Exception {
        this.proxyTest();
    }

    public void testImplicitProxyType() throws Exception {
        this.proxyTest();
    }

    public void testNoValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testEmptyValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testInvalidValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testUnknownElement() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testPatternValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testBrokenSetAttribute() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }

    public void testNoAttributeInfoType() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testAttributeInfoTypeNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testProxyTypeNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testProxyTypeNotInterface() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IllegalArgumentException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proxyTest() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            Simple dependency = this.getMBean(Simple.class, DEPENDS, "Instance");
            DependencyValueTest.assertFalse((boolean)simple.isTouched());
            DependencyValueTest.assertFalse((boolean)dependency.isTouched());
            simple.touchProxy();
            DependencyValueTest.assertFalse((boolean)simple.isTouched());
            DependencyValueTest.assertTrue((boolean)dependency.isTouched());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    protected Simple getDependency() throws Exception {
        return this.getMBean(Simple.class, DEPENDS, "Instance");
    }
}

