/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.configure.value.dependslist.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependencyListValueTest
extends AbstractControllerTest {
    static ObjectName DEPENDS1 = ObjectNameFactory.create((String)"jboss.test:type=depends1");
    static ObjectName[] DEPENDSLIST1 = new ObjectName[]{DEPENDS1};
    static ObjectName DEPENDS2 = ObjectNameFactory.create((String)"jboss.test:type=depends2");
    static ObjectName[] DEPENDSLIST2 = new ObjectName[]{DEPENDS1, DEPENDS2};

    public DependencyListValueTest(String name) {
        super(name);
    }

    protected void assertEquals(ObjectName[] expected, Collection<ObjectName> actual) {
        List<ObjectName> expectedList = Arrays.asList(expected);
        DependencyListValueTest.assertEquals(expectedList, actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNone() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(new ObjectName[0], simple.getObjectNames());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOne() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(DEPENDSLIST1, simple.getObjectNames());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwo() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(DEPENDSLIST2, simple.getObjectNames());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNested() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple simple = this.getSimple();
            this.assertEquals(DEPENDSLIST1, simple.getObjectNames());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    public void testNoValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testEmptyValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testInvalidValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testUnknownElement() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testPatternValue() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, MalformedObjectNameException.class);
    }

    public void testBrokenSetAttribute() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }
}

