/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.configure.value.inject.test;

import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import junit.framework.Test;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewInjectionValueUnitTestCase
extends AbstractControllerTest {
    private static ObjectName OTHER = ObjectNameFactory.create((String)"jboss.test:type=depends");

    public static Test suite() {
        return NewInjectionValueUnitTestCase.suite(NewInjectionValueUnitTestCase.class);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return NewInjectionValueUnitTestCase.getNewControllerDelegate(clazz);
    }

    public NewInjectionValueUnitTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInjection() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        List<ObjectName> names = this.assertDeploy(name);
        try {
            Simple test = this.getSimple();
            Simple other = this.getMBean(Simple.class, OTHER, "Instance");
            NewInjectionValueUnitTestCase.assertEquals((Object)other, (Object)test.getSimple());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.assertUndeploy(name, names);
            throw throwable;
        }
        this.assertUndeploy(name, names);
    }

    public void testInjectionNoBean() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, 0, null);
    }

    public void testInjectionBeanEmpty() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, 0, null);
    }

    public void testInjectionNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, 0, null);
    }

    public void testInjectionWrongType() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, InvalidAttributeValueException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInjectionProperty() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        List<ObjectName> names = this.assertDeploy(name);
        try {
            Simple test = this.getSimple();
            NewInjectionValueUnitTestCase.assertEquals((String)"PropertyInjection", (String)test.getAString());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.assertUndeploy(name, names);
            throw throwable;
        }
        this.assertUndeploy(name, names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInjectionPropertyState() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        List<ObjectName> names = this.assertDeploy(name);
        try {
            Simple test = this.getSimple();
            NewInjectionValueUnitTestCase.assertEquals((String)"Instantiated", (String)test.getAString());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.assertUndeploy(name, names);
            throw throwable;
        }
        this.assertUndeploy(name, names);
    }

    public void testInjectionPropertyNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, AttributeNotFoundException.class);
    }

    public void testInjectionPropertyWrongType() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, InvalidAttributeValueException.class);
    }
}

