/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.configure.value.javabean.test;

import java.beans.IntrospectionException;
import javax.management.ObjectName;
import org.jboss.system.ConfigurationException;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.BrokenDynamicMBeanAttributeInfoTypeNotFound;
import org.jboss.test.system.controller.support.BrokenDynamicMBeanNoAttributeInfoType;
import org.jboss.test.system.controller.support.JavaBean;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

public abstract class JavaBeanValueTest
extends AbstractControllerTest {
    public JavaBeanValueTest(String name) {
        super(name);
    }

    public void testExplicitClass() throws Exception {
        this.javaBean();
    }

    public void testImplicitClass() throws Exception {
        this.javaBean();
    }

    public void testAttributeClassNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testAbstractAttributeClass() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, InstantiationException.class);
    }

    public void testErrorInConstructor() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }

    public void testNoAttributeInfoType() throws Exception {
        this.assertDeployFailure(BrokenDynamicMBeanNoAttributeInfoType.OBJECT_NAME, ConfigurationException.class);
    }

    public void testAttributeInfoTypeNotFound() throws Exception {
        this.assertDeployFailure(BrokenDynamicMBeanAttributeInfoTypeNotFound.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testNoPropertyName() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IntrospectionException.class);
    }

    public void testEmptyPropertyName() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IntrospectionException.class);
    }

    public void testPropertyNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IntrospectionException.class);
    }

    public void testNoPropertyEditor() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoPropertyValue() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple test = this.getSimple();
            JavaBean bean = test.getJavaBean();
            JavaBeanValueTest.assertNotNull((Object)bean);
            JavaBeanValueTest.assertEquals((String)"", (String)bean.getProperty1());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    public void testErrorInProperty() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void javaBean() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple test = this.getSimple();
            JavaBean bean = test.getJavaBean();
            JavaBeanValueTest.assertNotNull((Object)bean);
            JavaBeanValueTest.assertEquals((String)"property1", (String)bean.getProperty1());
            JavaBeanValueTest.assertEquals((Object)new Integer(10), (Object)bean.getProperty2());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }
}

