/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.configure.value.jbxb.test;

import javax.management.ObjectName;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.JavaBean;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

public abstract class JBXBValueTest
extends AbstractControllerTest {
    public JBXBValueTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        this.javaBean();
    }

    public void testClassNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testAbstractClass() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, JoinpointException.class);
    }

    public void testErrorInConstructor() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }

    public void testNoPropertyName() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IllegalArgumentException.class);
    }

    public void testEmptyPropertyName() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IllegalArgumentException.class);
    }

    public void testPropertyNotFound() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IllegalArgumentException.class);
    }

    public void testNoPropertyEditor() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, IllegalArgumentException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoPropertyValue() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple test = this.getSimple();
            JavaBean bean = test.getJavaBean();
            JBXBValueTest.assertNotNull((Object)bean);
            JBXBValueTest.assertNull((Object)bean.getProperty1());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    public void testErrorInProperty() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void javaBean() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple test = this.getSimple();
            JavaBean bean = test.getJavaBean();
            JBXBValueTest.assertNotNull((Object)bean);
            JBXBValueTest.assertEquals((String)"property1", (String)bean.getProperty1());
            JBXBValueTest.assertEquals((Object)new Integer(10), (Object)bean.getProperty2());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }
}

