/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.configure.value.text.test;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.management.ObjectName;
import org.jboss.system.ConfigurationException;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.BrokenDynamicMBeanAttributeInfoTypeNotFound;
import org.jboss.test.system.controller.support.BrokenDynamicMBeanNoAttributeInfoType;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;
import org.jboss.util.NestedRuntimeException;

public abstract class TextValueTest
extends AbstractControllerTest {
    private Locale locale;
    private DateFormat dateFormat;
    private static final String stringValue = "StringValue";
    private static final Byte byteValue = new Byte("12");
    private static final Boolean booleanValue = Boolean.TRUE;
    private static final Short shortValue = new Short("123");
    private static final Integer integerValue = new Integer("1234");
    private static final Long longValue = new Long("12345");
    private static final Float floatValue = new Float("3.14");
    private static final Double doubleValue = new Double("3.14e12");
    private final Date dateValue = this.createDate("Mon Jan 01 00:00:00 CET 2001");
    private static final BigDecimal bigDecimalValue = new BigDecimal("12e4");

    public TextValueTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertyEditors() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        try {
            Simple test = this.getSimple();
            TextValueTest.assertEquals((String)stringValue, (String)test.getAString());
            TextValueTest.assertEquals((Object)byteValue, (Object)test.getAByte());
            TextValueTest.assertEquals((Object)booleanValue, (Object)test.getABoolean());
            TextValueTest.assertEquals((Object)shortValue, (Object)test.getAShort());
            TextValueTest.assertEquals((Object)integerValue, (Object)test.getAnInt());
            TextValueTest.assertEquals((Object)longValue, (Object)test.getALong());
            TextValueTest.assertEquals((Object)floatValue, (Object)test.getAFloat());
            TextValueTest.assertEquals((Object)doubleValue, (Object)test.getADouble());
            TextValueTest.assertEquals((Object)this.dateValue, (Object)test.getADate());
            TextValueTest.assertEquals((Object)bigDecimalValue, (Object)test.getABigDecimal());
            TextValueTest.assertEquals((byte)byteValue, (byte)test.getAbyte());
            TextValueTest.assertEquals((boolean)booleanValue, (boolean)test.isAboolean());
            TextValueTest.assertEquals((short)shortValue, (short)test.getAshort());
            TextValueTest.assertEquals((int)integerValue, (int)test.getAnint());
            TextValueTest.assertEquals((long)longValue, (long)test.getAlong());
            this.assertEquals(floatValue.floatValue(), test.getAfloat());
            this.assertEquals(doubleValue, test.getAdouble());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.assertUninstall(name);
            throw throwable;
        }
        this.assertUninstall(name);
    }

    public void testNoPropertyEditor() throws Exception {
        this.assertDeployFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testNoAttributeInfoType() throws Exception {
        this.assertDeployFailure(BrokenDynamicMBeanNoAttributeInfoType.OBJECT_NAME, ConfigurationException.class);
    }

    public void testAttributeInfoTypeNotFound() throws Exception {
        this.assertDeployFailure(BrokenDynamicMBeanAttributeInfoTypeNotFound.OBJECT_NAME, ClassNotFoundException.class);
    }

    protected Date createDate(String date) {
        Locale locale = Locale.getDefault();
        try {
            this.setLocale(Locale.US);
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
            }
            Date date2 = this.dateFormat.parse(date);
            Object var5_5 = null;
            this.setLocale(locale);
            return date2;
        }
        catch (Exception e) {
            try {
                throw new NestedRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.setLocale(locale);
                throw throwable;
            }
        }
    }

    protected void setUp() throws Exception {
        this.locale = Locale.getDefault();
        this.setLocale(Locale.US);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.setLocale(this.locale);
        this.locale = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocale(Locale locale) {
        SecurityManager sm = TextValueTest.suspendSecurity();
        try {
            Locale.setDefault(locale);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            TextValueTest.resumeSecurity((SecurityManager)sm);
            throw throwable;
        }
        TextValueTest.resumeSecurity((SecurityManager)sm);
    }
}

