/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.instantiate.plain.test;

import java.util.Collections;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jboss.system.ConfigurationException;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.BrokenDynamicMBean;
import org.jboss.test.system.controller.support.PostDeregisterError;
import org.jboss.test.system.controller.support.PostRegisterError;
import org.jboss.test.system.controller.support.PreDeregisterError;
import org.jboss.test.system.controller.support.PreRegisterError;
import org.jboss.test.system.controller.support.SimpleMBean;

public abstract class PlainMBeanTest
extends AbstractControllerTest {
    public PlainMBeanTest(String name) {
        super(name);
    }

    public void testPlainMBean() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        this.assertUninstall(name);
    }

    public void testPlainMBeanCodeMissing() throws Exception {
        this.assertMaybeParseFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testPlainMBeanCodeEmpty() throws Exception {
        this.assertMaybeParseFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testPlainMBeanCodeClassNotFound() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testPlainMBeanNotMBean() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, NotCompliantMBeanException.class);
    }

    public void testPlainMBeanAbstractClass() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, NotCompliantMBeanException.class);
    }

    public void testPlainMBeanConstructorError() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }

    public void testPlainMBeanConstructorException() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, RuntimeException.class);
    }

    public void testPlainMBeanConstructorTypeNotFound() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testPlainMBeanConstructorInvalidType() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testPlainMBeanConstructorInvalidValue() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, NumberFormatException.class);
    }

    public void testPlainMBeanGetMBeanInfoError() throws Exception {
        this.assertMaybeDeployFailure(BrokenDynamicMBean.OBJECT_NAME, Error.class);
    }

    public void testPlainMBeanPreRegisterError() throws Exception {
        this.assertMaybeDeployFailure(PreRegisterError.OBJECT_NAME, Error.class);
    }

    public void testPlainMBeanPostRegisterError() throws Exception {
        this.assertMaybeDeployFailure(PostRegisterError.OBJECT_NAME, Error.class);
    }

    public void testPlainMBeanPreDeregisterError() throws Exception {
        ObjectName name = PreDeregisterError.OBJECT_NAME;
        this.assertInstall(name);
        this.uninstall(Collections.singletonList(name));
        this.assertNoService(name);
        this.assertRegistered(name);
    }

    public void testPlainMBeanPostDeregisterError() throws Exception {
        ObjectName name = PostDeregisterError.OBJECT_NAME;
        this.assertInstall(name);
        this.assertUninstall(name);
    }
}

