/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.instantiate.standard.test;

import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jboss.system.ConfigurationException;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.SimpleMBean;

public abstract class StandardMBeanTest
extends AbstractControllerTest {
    public StandardMBeanTest(String name) {
        super(name);
    }

    public void testStandardMBean() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        this.assertUninstall(name);
    }

    public void testStandardMBeanInterface() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        this.assertInstall(name);
        String result = (String)this.getServer().invoke(name, "echoReverse", new Object[]{"12345"}, new String[]{String.class.getName()});
        StandardMBeanTest.assertEquals((String)"54321", (String)result);
        this.assertUninstall(name);
    }

    public void testStandardMBeanInterfaceNotFound() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testStandardMBeanInterfaceNotImplemented() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, NotCompliantMBeanException.class);
    }

    public void testStandardMBeanCodeMissing() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testStandardMBeanCodeEmpty() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testStandardMBeanCodeClassNotFound() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testStandardMBeanAbstractClass() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, InstantiationException.class);
    }

    public void testStandardMBeanConstructorError() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, Error.class);
    }

    public void testStandardMBeanConstructorException() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, RuntimeException.class);
    }

    public void testStandardMBeanConstructorTypeNotFound() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ClassNotFoundException.class);
    }

    public void testStandardMBeanConstructorInvalidType() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, ConfigurationException.class);
    }

    public void testStandardMBeanConstructorInvalidValue() throws Exception {
        this.assertMaybeDeployFailure(SimpleMBean.OBJECT_NAME, NumberFormatException.class);
    }
}

