/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.instantiate.test;

import javax.management.MBeanServer;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

public abstract class ConstructorArgsTest
extends AbstractControllerTest {
    public ConstructorArgsTest(String name) {
        super(name);
    }

    public void testPlainMBeanNoArg() throws Exception {
        this.noArg();
    }

    public void testPlainMBeanOneArg() throws Exception {
        this.oneArg();
    }

    public void testPlainMBeanTwoArg() throws Exception {
        this.twoArg();
    }

    public void testStandardMBeanNoArg() throws Exception {
        this.noArg();
    }

    public void testStandardMBeanOneArg() throws Exception {
        this.oneArg();
    }

    public void testStandardMBeanTwoArg() throws Exception {
        this.twoArg();
    }

    protected void noArg() throws Exception {
        Simple simple = this.getSimple();
        ConstructorArgsTest.assertEquals((String)"()", (String)simple.constructorUsed);
    }

    protected void oneArg() throws Exception {
        Simple simple = this.getSimple();
        ConstructorArgsTest.assertEquals((String)"(int)", (String)simple.constructorUsed);
        ConstructorArgsTest.assertEquals((int)5, (int)simple.getAnint());
    }

    protected void twoArg() throws Exception {
        Simple simple = this.getSimple();
        ConstructorArgsTest.assertEquals((String)"(int,float)", (String)simple.constructorUsed);
        ConstructorArgsTest.assertEquals((int)5, (int)simple.getAnint());
        this.assertEquals(3.14f, simple.getAfloat());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.assertInstall(SimpleMBean.OBJECT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.assertUninstall(SimpleMBean.OBJECT_NAME);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.tearDown();
            throw throwable;
        }
        super.tearDown();
    }

    protected Simple getSimple() throws Exception {
        MBeanServer server = this.getServer();
        return (Simple)server.getAttribute(SimpleMBean.OBJECT_NAME, "Instance");
    }
}

