/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.integration.test;

import java.net.URL;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.test.system.controller.NewControllerTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationTestDelegate
extends NewControllerTestDelegate {
    protected Kernel kernel;
    protected BasicXMLDeployer beanDeployer;

    public IntegrationTestDelegate(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.beanDeployer = new BasicXMLDeployer(this.kernel);
            this.deployMC();
            this.validateMC();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isValidateAtSetUp() {
        return false;
    }

    @Override
    public ServiceControllerMBean createServiceController() throws Exception {
        try {
            AbstractBootstrap bootstrap = this.getBootstrap();
            bootstrap.run();
            this.kernel = bootstrap.getKernel();
            ServiceController result = new ServiceController();
            result.setKernel(this.kernel);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.undeployMC();
        super.tearDown();
    }

    protected AbstractBootstrap getBootstrap() throws Exception {
        return new BasicBootstrap();
    }

    protected Object getBean(Object name, ControllerState state) {
        ControllerContext context = this.getControllerContext(name, state);
        return context.getTarget();
    }

    protected ControllerContext getControllerContext(Object name, ControllerState state) {
        KernelController controller = this.kernel.getController();
        ControllerContext context = controller.getContext(name, state);
        if (context == null) {
            throw new IllegalStateException("Context not found: " + name);
        }
        return context;
    }

    protected void validateMC() throws Exception {
        try {
            this.beanDeployer.validate();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected KernelDeployment deployMC(URL url) throws Exception {
        try {
            this.log.debug((Object)("Deploying " + url));
            KernelDeployment deployment = this.beanDeployer.deploy(url);
            this.log.trace((Object)("Deployed " + url));
            return deployment;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected void undeployMC(URL url) {
        this.log.debug((Object)("Undeploying " + url));
        try {
            this.beanDeployer.undeploy(url);
            this.log.trace((Object)("Undeployed " + url));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during undeployment: " + url), t);
        }
    }

    protected void undeployMC(KernelDeployment deployment) {
        this.log.debug((Object)("Undeploying " + deployment.getName()));
        try {
            this.beanDeployer.undeploy(deployment);
            this.log.trace((Object)("Undeployed " + deployment.getName()));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during undeployment: " + deployment.getName()), t);
        }
    }

    protected void deployMC() throws Exception {
        String testName = this.clazz.getName();
        testName = testName.replace('.', '/') + "-mc.xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            this.deployMC(url);
        } else {
            this.log.debug((Object)("No test specific deployment " + testName));
        }
    }

    protected void undeployMC() {
        this.log.debug((Object)("Undeploying " + this.beanDeployer.getDeploymentNames()));
        this.beanDeployer.shutdown();
    }
}

