/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.legacy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.Service;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceFactory;
import org.jboss.test.system.controller.legacy.DeploymentException;
import org.jboss.test.system.controller.legacy.OldServiceConfigurator;
import org.jboss.test.system.controller.legacy.OldServiceControllerMBean;
import org.jboss.test.system.controller.legacy.OldServiceCreator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldServiceController
extends JBossNotificationBroadcasterSupport
implements OldServiceControllerMBean,
MBeanRegistration {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    public static final String JBOSS_INTERNAL_LIFECYCLE = "jbossInternalLifecycle";
    public static final String[] JBOSS_INTERNAL_LIFECYCLE_SIG = new String[]{String.class.getName()};
    private static final Logger log = Logger.getLogger(OldServiceController.class);
    protected MBeanServer server;
    protected OldServiceCreator creator;
    protected OldServiceConfigurator configurator;
    protected Map<ObjectName, ServiceContext> nameToServiceMap = Collections.synchronizedMap(new HashMap());
    protected List<ServiceContext> installedServices = new LinkedList<ServiceContext>();
    private static HashMap<String, Integer> serviceOpMap = new HashMap();

    public List<ServiceContext> listDeployed() {
        return new ArrayList<ServiceContext>(this.installedServices);
    }

    public List<ServiceContext> listIncompletelyDeployed() {
        ArrayList<ServiceContext> id = new ArrayList<ServiceContext>();
        for (ServiceContext sc : this.installedServices) {
            if (sc.state == 2 || sc.state == 3 || sc.state == 5 || sc.state == 6) continue;
            id.add(sc);
        }
        return id;
    }

    public List<ObjectName> listDeployedNames() {
        ArrayList<ObjectName> names = new ArrayList<ObjectName>(this.installedServices.size());
        for (ServiceContext ctx : this.installedServices) {
            names.add(ctx.objectName);
        }
        return names;
    }

    public String listConfiguration(ObjectName[] objectNames) throws Exception {
        return this.configurator.getConfiguration(objectNames);
    }

    public synchronized List<ObjectName> install(Element config, ObjectName loaderName) throws DeploymentException {
        List<ObjectName> mbeans = this.configurator.install(config, loaderName);
        for (ObjectName mbean : mbeans) {
            this.installedServices.add(this.createServiceContext(mbean));
        }
        return mbeans;
    }

    public synchronized void register(ObjectName serviceName) throws Exception {
        this.register(serviceName, null);
    }

    public synchronized void register(ObjectName serviceName, Collection<ObjectName> depends) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to register null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("Registering service " + serviceName));
        ServiceContext ctx = this.createServiceContext(serviceName);
        this.register(ctx, depends);
    }

    public synchronized void create(ObjectName serviceName) throws Exception {
        this.create(serviceName, null);
    }

    public synchronized void create(ObjectName serviceName, Collection<ObjectName> depends) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to create null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("Creating service " + serviceName));
        ServiceContext ctx = this.createServiceContext(serviceName);
        this.register(ctx, depends);
        if (ctx.state == 2 || ctx.state == 3 || ctx.state == 4) {
            log.debug((Object)("Ignoring create request for service: " + ctx.objectName));
            return;
        }
        int oldState = ctx.state;
        ctx.state = 2;
        for (ServiceContext sc : ctx.iDependOn) {
            int state = sc.state;
            if (state == 2 || state == 3) continue;
            log.debug((Object)("waiting in create of " + serviceName + " waiting on " + sc.objectName));
            ctx.state = oldState;
            return;
        }
        try {
            ctx.proxy.create();
            this.sendControllerNotification("org.jboss.system.ServiceMBean.create", serviceName);
        }
        catch (Throwable e) {
            ctx.state = 4;
            ctx.problem = e;
            log.warn((Object)("Problem creating service " + serviceName), e);
            return;
        }
        log.debug((Object)("Creating dependent components for: " + serviceName + " dependents are: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            this.create(ctx2.objectName);
        }
        tmp.clear();
    }

    public synchronized void start(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to start null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("starting service " + serviceName));
        ServiceContext ctx = this.createServiceContext(serviceName);
        if (!this.installedServices.contains(ctx)) {
            this.installedServices.add(ctx);
        }
        if (ctx.state == 3 || ctx.state == 4) {
            log.debug((Object)("Ignoring start request for service: " + ctx.objectName));
            return;
        }
        if (ctx.state != 2 && ctx.state != 5) {
            log.debug((Object)("Start requested before create, calling create now for service: " + serviceName));
            this.create(serviceName);
        }
        if (ctx.proxy == null) {
            ctx.proxy = this.getServiceProxy(ctx.objectName, null);
        }
        int oldState = ctx.state;
        ctx.state = 3;
        for (ServiceContext sctx : ctx.iDependOn) {
            int state = sctx.state;
            if (state == 3) continue;
            log.debug((Object)("waiting in start " + serviceName + " on " + sctx.objectName));
            ctx.state = oldState;
            return;
        }
        try {
            ctx.proxy.start();
            this.sendControllerNotification("org.jboss.system.ServiceMBean.start", serviceName);
        }
        catch (Throwable e) {
            ctx.state = 4;
            ctx.problem = e;
            log.warn((Object)("Problem starting service " + serviceName), e);
            return;
        }
        log.debug((Object)("Starting dependent components for: " + serviceName + " dependent components: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            this.start(ctx2.objectName);
        }
        tmp.clear();
    }

    public void restart(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to restart null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("restarting service " + serviceName));
        this.stop(serviceName);
        this.start(serviceName);
    }

    public void stop(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to stop null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        ServiceContext ctx = this.nameToServiceMap.get(serviceName);
        log.debug((Object)("stopping service: " + serviceName));
        if (ctx == null) {
            log.warn((Object)("Ignoring request to stop nonexistent service: " + serviceName));
            return;
        }
        if (ctx.state != 3) {
            return;
        }
        ctx.state = 5;
        log.debug((Object)("stopping dependent services for: " + serviceName + " dependent services are: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            ObjectName other = ctx2.objectName;
            this.stop(other);
        }
        tmp.clear();
        if (ctx.proxy != null) {
            try {
                ctx.proxy.stop();
                this.sendControllerNotification("org.jboss.system.ServiceMBean.stop", serviceName);
            }
            catch (Throwable e) {
                ctx.state = 4;
                ctx.problem = e;
                log.warn((Object)("Problem stopping service " + serviceName), e);
            }
        }
    }

    public void destroy(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to destroy null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        ServiceContext ctx = this.nameToServiceMap.get(serviceName);
        log.debug((Object)("destroying service: " + serviceName));
        if (ctx == null) {
            log.warn((Object)("Ignoring request to destroy nonexistent service: " + serviceName));
            return;
        }
        if (ctx.state == 6 || ctx.state == 7) {
            return;
        }
        if (ctx.state == 3) {
            log.debug((Object)("Destroy requested before stop, calling stop now for service: " + serviceName));
            this.stop(serviceName);
        }
        ctx.state = 6;
        log.debug((Object)("destroying dependent services for: " + serviceName + " dependent services are: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            ObjectName other = ctx2.objectName;
            this.destroy(other);
        }
        tmp.clear();
        if (ctx.proxy != null) {
            try {
                ctx.proxy.destroy();
                this.sendControllerNotification("org.jboss.system.ServiceMBean.destroy", serviceName);
            }
            catch (Throwable e) {
                ctx.state = 4;
                ctx.problem = e;
                log.warn((Object)("Problem destroying service " + serviceName), e);
            }
        }
    }

    public void remove(ObjectName objectName) throws Exception {
        if (objectName == null) {
            log.warn((Object)"Ignoring request to remove null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        ServiceContext ctx = this.nameToServiceMap.get(objectName);
        if (ctx == null) {
            log.debug((Object)("Ignoring request to remove nonexistent service: " + objectName));
            return;
        }
        log.debug((Object)("removing service: " + objectName));
        for (ServiceContext iDependOnContext : ctx.iDependOn) {
            iDependOnContext.dependsOnMe.remove(ctx);
            if (iDependOnContext.state != 7 || iDependOnContext.dependsOnMe.size() != 0) continue;
            this.nameToServiceMap.remove(iDependOnContext.objectName);
            log.debug((Object)("Removing context for nonexistent service it is no longer recording dependencies: " + iDependOnContext));
        }
        ctx.iDependOn.clear();
        if (this.server.isRegistered(objectName)) {
            log.debug((Object)("removing " + objectName + " from server"));
            if (ctx.dependsOnMe.size() == 0) {
                this.nameToServiceMap.remove(objectName);
            } else {
                log.debug((Object)("Context not removed, it is recording dependencies: " + ctx));
                ctx.proxy = null;
            }
            this.installedServices.remove(ctx);
            this.creator.remove(objectName);
        } else {
            this.installedServices.remove(ctx);
            if (ctx.dependsOnMe.size() == 0) {
                log.debug((Object)("removing already unregistered " + objectName + " from server"));
                this.nameToServiceMap.remove(objectName);
            } else {
                log.debug((Object)("no need to remove " + objectName + " from server"));
                ctx.proxy = null;
            }
        }
        ctx.state = 7;
    }

    public ServiceContext getServiceContext(ObjectName serviceName) {
        ServiceContext ctx = this.nameToServiceMap.get(serviceName);
        return ctx;
    }

    public void shutdown() {
        log.debug((Object)("Stopping " + this.nameToServiceMap.size() + " services"));
        ArrayList<ServiceContext> servicesCopy = new ArrayList<ServiceContext>(this.installedServices);
        int serviceCounter = 0;
        ObjectName name = null;
        ListIterator i = servicesCopy.listIterator(servicesCopy.size());
        while (i.hasPrevious()) {
            ServiceContext ctx = (ServiceContext)i.previous();
            name = ctx.objectName;
            try {
                this.stop(name);
            }
            catch (Throwable e) {
                log.error((Object)("Could not stop mbean: " + name), e);
            }
            try {
                this.destroy(name);
            }
            catch (Throwable e) {
                log.error((Object)("Could not destroy mbean: " + name), e);
            }
            try {
                this.remove(name);
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error((Object)("Could not remove mbean: " + name), e);
            }
        }
        log.debug((Object)("Stopped " + serviceCounter + " services"));
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.creator = new OldServiceCreator(server);
        this.configurator = new OldServiceConfigurator(server, this, this.creator);
        ServiceContext sc = this.createServiceContext(name);
        sc.state = 3;
        log.debug((Object)"Controller MBean online");
        return name == null ? OBJECT_NAME : name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            log.info((Object)"Registration of ServiceController failed");
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.nameToServiceMap.clear();
        this.installedServices.clear();
        this.creator.shutdown();
        this.creator = null;
        this.configurator = null;
        this.server = null;
    }

    synchronized ServiceContext createServiceContext(ObjectName objectName) {
        if (this.nameToServiceMap.containsKey(objectName)) {
            return this.nameToServiceMap.get(objectName);
        }
        ServiceContext ctx = new ServiceContext();
        ctx.objectName = objectName;
        this.nameToServiceMap.put(objectName, ctx);
        return ctx;
    }

    void registerDependency(ObjectName needs, ObjectName used) {
        log.debug((Object)("recording that " + needs + " depends on " + used));
        ServiceContext needsCtx = this.createServiceContext(needs);
        ServiceContext usedCtx = this.createServiceContext(used);
        if (!needsCtx.iDependOn.contains(usedCtx)) {
            needsCtx.iDependOn.add(usedCtx);
            usedCtx.dependsOnMe.add(needsCtx);
        }
    }

    private void register(ServiceContext ctx, Collection depends) throws Exception {
        if (!this.installedServices.contains(ctx)) {
            this.installedServices.add(ctx);
        }
        if (depends != null) {
            log.debug((Object)("adding depends in ServiceController.register: " + depends));
            Iterator i = depends.iterator();
            while (i.hasNext()) {
                this.registerDependency(ctx.objectName, (ObjectName)i.next());
            }
        }
        if (ctx.proxy == null) {
            ctx.proxy = this.getServiceProxy(ctx.objectName, null);
        }
    }

    private Service getServiceProxy(ObjectName objectName, String serviceFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JMException {
        Service service = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (serviceFactory != null && serviceFactory.length() > 0) {
            Class<?> clazz = loader.loadClass(serviceFactory);
            ServiceFactory factory = (ServiceFactory)clazz.newInstance();
            service = factory.createService(this.server, objectName);
        } else {
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            MBeanOperationInfo[] opInfo = info.getOperations();
            Class[] interfaces = new Class[]{Service.class};
            ServiceProxy handler = new ServiceProxy(objectName, opInfo);
            service = (Service)Proxy.newProxyInstance(Service.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return service;
    }

    private void sendControllerNotification(String type, ObjectName serviceName) {
        Notification notification = new Notification(type, this, super.nextNotificationSequenceNumber());
        notification.setUserData(serviceName);
        this.sendNotification(notification);
    }

    static {
        serviceOpMap.put("create", new Integer(0));
        serviceOpMap.put("start", new Integer(1));
        serviceOpMap.put("destroy", new Integer(2));
        serviceOpMap.put("stop", new Integer(3));
    }

    public class ServiceProxy
    implements InvocationHandler {
        private boolean[] hasOp = new boolean[]{false, false, false, false};
        private ObjectName objectName;
        private boolean hasJBossInternalLifecycle;

        public ServiceProxy(ObjectName objectName, MBeanOperationInfo[] opInfo) {
            this.objectName = objectName;
            for (int op = 0; op < opInfo.length; ++op) {
                MBeanOperationInfo info = opInfo[op];
                String name = info.getName();
                if (name.equals(OldServiceController.JBOSS_INTERNAL_LIFECYCLE)) {
                    this.hasJBossInternalLifecycle = true;
                    continue;
                }
                Integer opID = (Integer)serviceOpMap.get(name);
                if (opID == null || !info.getReturnType().equals("void") || info.getSignature().length != 0) continue;
                this.hasOp[opID.intValue()] = true;
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (this.hasJBossInternalLifecycle) {
                try {
                    OldServiceController.this.server.invoke(this.objectName, OldServiceController.JBOSS_INTERNAL_LIFECYCLE, new Object[]{name}, JBOSS_INTERNAL_LIFECYCLE_SIG);
                    return null;
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode((Throwable)e);
                }
            }
            Integer opID = (Integer)serviceOpMap.get(name);
            if (opID != null && this.hasOp[opID]) {
                try {
                    String[] sig = new String[]{};
                    OldServiceController.this.server.invoke(this.objectName, name, args, sig);
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode((Throwable)e);
                }
            }
            return null;
        }
    }
}

