/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.lifecycle.basic.test;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;

public abstract class BasicDependencyTest
extends AbstractControllerTest {
    private static ObjectName NAME_ONE = ObjectNameFactory.create((String)"test:name=1");
    private static ObjectName NAME_TWO = ObjectNameFactory.create((String)"test:name=2");
    private String resourceName = ((Object)((Object)this)).getClass().getName();

    public BasicDependencyTest(String name) {
        super(name);
        int index = this.resourceName.lastIndexOf(46);
        if (index != -1) {
            this.resourceName = this.resourceName.substring(index + 1, this.resourceName.length());
        }
        if ((index = this.resourceName.indexOf("NewUnitTestCase")) != -1) {
            this.resourceName = this.resourceName.substring(0, index);
        }
        if ((index = this.resourceName.indexOf("OldUnitTestCase")) != -1) {
            this.resourceName = this.resourceName.substring(0, index);
        }
        if ((index = this.resourceName.indexOf("PlainUnitTestCase")) != -1) {
            this.resourceName = this.resourceName.substring(0, index);
        }
        this.resourceName = this.resourceName + "_NotAutomatic.xml";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBasicDependency() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans = this.deploy(this.resourceName);
        try {
            try {
                this.assertServiceRunning(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                MBeanServer server = this.getServer();
                test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
            BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
            BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
            BasicDependencyTest.assertEquals((int)7, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
            BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
            BasicDependencyTest.assertEquals((int)6, (int)test2.stopOrder);
            BasicDependencyTest.assertEquals((int)8, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
        BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
        BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
        BasicDependencyTest.assertEquals((int)7, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
        BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
        BasicDependencyTest.assertEquals((int)6, (int)test2.stopOrder);
        BasicDependencyTest.assertEquals((int)8, (int)test2.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBasicRedeploy() throws Exception {
        MBeanServer server;
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans = this.deploy(this.resourceName);
        try {
            try {
                this.assertServiceRunning(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                server = this.getServer();
                test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
            BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
            BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
            BasicDependencyTest.assertEquals((int)7, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
            BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
            BasicDependencyTest.assertEquals((int)6, (int)test2.stopOrder);
            BasicDependencyTest.assertEquals((int)8, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (!error) {
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
            BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
            BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
            BasicDependencyTest.assertEquals((int)7, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
            BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
            BasicDependencyTest.assertEquals((int)6, (int)test2.stopOrder);
            BasicDependencyTest.assertEquals((int)8, (int)test2.destroyOrder);
        }
        mbeans = this.deploy(this.resourceName);
        try {
            try {
                this.assertServiceRunning(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                server = this.getServer();
                test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                BasicDependencyTest.assertEquals((int)10, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)12, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                BasicDependencyTest.assertEquals((int)9, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)11, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            BasicDependencyTest.assertEquals((int)10, (int)test1.createOrder);
            BasicDependencyTest.assertEquals((int)12, (int)test1.startOrder);
            BasicDependencyTest.assertEquals((int)13, (int)test1.stopOrder);
            BasicDependencyTest.assertEquals((int)15, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            BasicDependencyTest.assertEquals((int)9, (int)test2.createOrder);
            BasicDependencyTest.assertEquals((int)11, (int)test2.startOrder);
            BasicDependencyTest.assertEquals((int)14, (int)test2.stopOrder);
            BasicDependencyTest.assertEquals((int)16, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        BasicDependencyTest.assertEquals((int)10, (int)test1.createOrder);
        BasicDependencyTest.assertEquals((int)12, (int)test1.startOrder);
        BasicDependencyTest.assertEquals((int)13, (int)test1.stopOrder);
        BasicDependencyTest.assertEquals((int)15, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        BasicDependencyTest.assertEquals((int)9, (int)test2.createOrder);
        BasicDependencyTest.assertEquals((int)11, (int)test2.startOrder);
        BasicDependencyTest.assertEquals((int)14, (int)test2.stopOrder);
        BasicDependencyTest.assertEquals((int)16, (int)test2.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBasicDependencyManualLifecycle() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans = this.deploy(this.resourceName);
        try {
            try {
                this.assertServiceRunning(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                MBeanServer server = this.getServer();
                test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                BasicDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                ServiceControllerMBean controller = this.getController();
                controller.stop(NAME_ONE);
                this.assertServiceStopped(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                controller.destroy(NAME_ONE);
                this.assertServiceDestroyed(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                BasicDependencyTest.assertEquals((int)2, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)6, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                controller.create(NAME_ONE);
                this.assertServiceCreated(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                BasicDependencyTest.assertEquals((int)7, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)4, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)6, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                controller.start(NAME_ONE);
                this.assertServiceRunning(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                BasicDependencyTest.assertEquals((int)7, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)8, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)5, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)6, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                controller.stop(NAME_TWO);
                this.assertServiceStopped(NAME_ONE);
                this.assertServiceStopped(NAME_TWO);
                BasicDependencyTest.assertEquals((int)7, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)8, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)9, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)6, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)10, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                controller.destroy(NAME_TWO);
                this.assertServiceDestroyed(NAME_ONE);
                this.assertServiceDestroyed(NAME_TWO);
                BasicDependencyTest.assertEquals((int)7, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)8, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)9, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)11, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)1, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)10, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)12, (int)test2.destroyOrder);
                controller.create(NAME_TWO);
                this.assertServiceCreated(NAME_ONE);
                this.assertServiceCreated(NAME_TWO);
                BasicDependencyTest.assertEquals((int)14, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)8, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)9, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)11, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)13, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)3, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)10, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)12, (int)test2.destroyOrder);
                controller.start(NAME_TWO);
                this.assertServiceRunning(NAME_ONE);
                this.assertServiceRunning(NAME_TWO);
                BasicDependencyTest.assertEquals((int)14, (int)test1.createOrder);
                BasicDependencyTest.assertEquals((int)16, (int)test1.startOrder);
                BasicDependencyTest.assertEquals((int)9, (int)test1.stopOrder);
                BasicDependencyTest.assertEquals((int)11, (int)test1.destroyOrder);
                BasicDependencyTest.assertEquals((int)13, (int)test2.createOrder);
                BasicDependencyTest.assertEquals((int)15, (int)test2.startOrder);
                BasicDependencyTest.assertEquals((int)10, (int)test2.stopOrder);
                BasicDependencyTest.assertEquals((int)12, (int)test2.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            BasicDependencyTest.assertEquals((int)14, (int)test1.createOrder);
            BasicDependencyTest.assertEquals((int)16, (int)test1.startOrder);
            BasicDependencyTest.assertEquals((int)17, (int)test1.stopOrder);
            BasicDependencyTest.assertEquals((int)19, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            BasicDependencyTest.assertEquals((int)13, (int)test2.createOrder);
            BasicDependencyTest.assertEquals((int)15, (int)test2.startOrder);
            BasicDependencyTest.assertEquals((int)18, (int)test2.stopOrder);
            BasicDependencyTest.assertEquals((int)20, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        BasicDependencyTest.assertEquals((int)14, (int)test1.createOrder);
        BasicDependencyTest.assertEquals((int)16, (int)test1.startOrder);
        BasicDependencyTest.assertEquals((int)17, (int)test1.stopOrder);
        BasicDependencyTest.assertEquals((int)19, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        BasicDependencyTest.assertEquals((int)13, (int)test2.createOrder);
        BasicDependencyTest.assertEquals((int)15, (int)test2.startOrder);
        BasicDependencyTest.assertEquals((int)18, (int)test2.stopOrder);
        BasicDependencyTest.assertEquals((int)20, (int)test2.destroyOrder);
    }
}

