/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.lifecycle.basic.test;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;
import org.jboss.test.system.controller.support.SimpleMBean;

public abstract class BasicLifecycleTest
extends AbstractControllerTest {
    public BasicLifecycleTest(String name) {
        super(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBasicLifecyle() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        Simple test = null;
        boolean error = false;
        List<ObjectName> mbeans = this.deploy("BasicLifecycle_NotAutomatic.xml");
        try {
            try {
                this.assertServiceRunning(name);
                MBeanServer server = this.getServer();
                test = (Simple)server.getAttribute(name, "Instance");
                BasicLifecycleTest.assertEquals((String)"()", (String)test.constructorUsed);
                BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(name);
            this.assertNotRegistered(name);
            BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
            BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
            BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
            BasicLifecycleTest.assertEquals((int)4, (int)test.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (error) return;
        this.assertNoService(name);
        this.assertNotRegistered(name);
        BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
        BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
        BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
        BasicLifecycleTest.assertEquals((int)4, (int)test.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBasicRedeploy() throws Exception {
        MBeanServer server;
        ObjectName name = SimpleMBean.OBJECT_NAME;
        Simple test = null;
        boolean error = false;
        List<ObjectName> mbeans = this.deploy("BasicLifecycle_NotAutomatic.xml");
        try {
            try {
                this.assertServiceRunning(name);
                server = this.getServer();
                test = (Simple)server.getAttribute(name, "Instance");
                BasicLifecycleTest.assertEquals((String)"()", (String)test.constructorUsed);
                BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(name);
            this.assertNotRegistered(name);
            BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
            BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
            BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
            BasicLifecycleTest.assertEquals((int)4, (int)test.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (!error) {
            this.assertNoService(name);
            this.assertNotRegistered(name);
            BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
            BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
            BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
            BasicLifecycleTest.assertEquals((int)4, (int)test.destroyOrder);
        }
        mbeans = this.deploy("BasicLifecycle_NotAutomatic.xml");
        try {
            try {
                this.assertServiceRunning(name);
                server = this.getServer();
                test = (Simple)server.getAttribute(name, "Instance");
                BasicLifecycleTest.assertEquals((String)"()", (String)test.constructorUsed);
                BasicLifecycleTest.assertEquals((int)5, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)6, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(name);
            this.assertNotRegistered(name);
            BasicLifecycleTest.assertEquals((int)5, (int)test.createOrder);
            BasicLifecycleTest.assertEquals((int)6, (int)test.startOrder);
            BasicLifecycleTest.assertEquals((int)7, (int)test.stopOrder);
            BasicLifecycleTest.assertEquals((int)8, (int)test.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (error) return;
        this.assertNoService(name);
        this.assertNotRegistered(name);
        BasicLifecycleTest.assertEquals((int)5, (int)test.createOrder);
        BasicLifecycleTest.assertEquals((int)6, (int)test.startOrder);
        BasicLifecycleTest.assertEquals((int)7, (int)test.stopOrder);
        BasicLifecycleTest.assertEquals((int)8, (int)test.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBasicManualLifecycle() throws Exception {
        ObjectName name = SimpleMBean.OBJECT_NAME;
        Simple test = null;
        boolean error = false;
        List<ObjectName> mbeans = this.deploy("BasicLifecycle_NotAutomatic.xml");
        try {
            try {
                this.assertServiceRunning(name);
                MBeanServer server = this.getServer();
                test = (Simple)server.getAttribute(name, "Instance");
                BasicLifecycleTest.assertEquals((String)"()", (String)test.constructorUsed);
                BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.destroyOrder);
                ServiceControllerMBean controller = this.getController();
                controller.stop(name);
                this.assertServiceStopped(name);
                BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)0, (int)test.destroyOrder);
                controller.destroy(name);
                this.assertServiceDestroyed(name);
                BasicLifecycleTest.assertEquals((int)1, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)4, (int)test.destroyOrder);
                controller.create(name);
                this.assertServiceCreated(name);
                BasicLifecycleTest.assertEquals((int)5, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)2, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)4, (int)test.destroyOrder);
                controller.start(name);
                this.assertServiceRunning(name);
                BasicLifecycleTest.assertEquals((int)5, (int)test.createOrder);
                BasicLifecycleTest.assertEquals((int)6, (int)test.startOrder);
                BasicLifecycleTest.assertEquals((int)3, (int)test.stopOrder);
                BasicLifecycleTest.assertEquals((int)4, (int)test.destroyOrder);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.undeploy(mbeans);
            if (error) throw throwable;
            this.assertNoService(name);
            this.assertNotRegistered(name);
            BasicLifecycleTest.assertEquals((int)5, (int)test.createOrder);
            BasicLifecycleTest.assertEquals((int)6, (int)test.startOrder);
            BasicLifecycleTest.assertEquals((int)7, (int)test.stopOrder);
            BasicLifecycleTest.assertEquals((int)8, (int)test.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans);
        if (error) return;
        this.assertNoService(name);
        this.assertNotRegistered(name);
        BasicLifecycleTest.assertEquals((int)5, (int)test.createOrder);
        BasicLifecycleTest.assertEquals((int)6, (int)test.startOrder);
        BasicLifecycleTest.assertEquals((int)7, (int)test.stopOrder);
        BasicLifecycleTest.assertEquals((int)8, (int)test.destroyOrder);
    }
}

