/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.lifecycle.seperated.test;

import java.util.List;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.system.controller.AbstractControllerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependsBrokenTest
extends AbstractControllerTest {
    private static ObjectName NAME_ONE = ObjectNameFactory.create((String)"test:name=1");
    private static ObjectName NAME_TWO = ObjectNameFactory.create((String)"test:name=2");
    private String resourceName1;
    private String resourceName2;

    public DependsBrokenTest(String name) {
        super(name);
        String resourceName = ((Object)((Object)this)).getClass().getName();
        int index = resourceName.lastIndexOf(46);
        if (index != -1) {
            resourceName = resourceName.substring(index + 1, resourceName.length());
        }
        if ((index = resourceName.indexOf("NewUnitTestCase")) != -1) {
            resourceName = resourceName.substring(0, index);
        }
        if ((index = resourceName.indexOf("OldUnitTestCase")) != -1) {
            resourceName = resourceName.substring(0, index);
        }
        if (index != -1) {
            resourceName = resourceName.substring(0, index);
        }
        if ((index = resourceName.indexOf("PlainUnitTestCase")) != -1) {
            resourceName = resourceName.substring(0, index);
        }
        this.resourceName1 = resourceName + "_bad.xml";
        this.resourceName2 = resourceName + "_good.xml";
    }

    public void deployBrokenFirstMaybeDeployFailure(int expectedState, Class<? extends Throwable> expected) throws Exception {
        boolean error = false;
        List<ObjectName> mbeans1 = this.assertMaybeDeployFailure(this.resourceName1, NAME_ONE, expected);
        try {
            List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
            try {
                this.assertServiceState(NAME_TWO, expectedState);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            finally {
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                }
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        catch (Error e) {
            error = true;
            throw e;
        }
        finally {
            this.undeploy(mbeans1);
            if (!error) {
                this.assertNoService(NAME_ONE);
                this.assertNotRegistered(NAME_ONE);
                this.assertNoService(NAME_TWO);
                this.assertNotRegistered(NAME_TWO);
            }
        }
    }

    public void deployBrokenSecondMaybeDeployFailure(int expectedState, Class<? extends Throwable> expected) throws Exception {
        boolean error = false;
        List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
        try {
            this.assertServiceState(NAME_TWO, expectedState);
            this.assertRegistered(NAME_TWO);
            List<ObjectName> mbeans1 = this.assertMaybeDeployFailure(this.resourceName1, NAME_ONE, expected);
            try {
                this.assertServiceState(NAME_TWO, expectedState);
                this.assertRegistered(NAME_TWO);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            finally {
                this.undeploy(mbeans1);
                if (!error) {
                    this.assertServiceState(NAME_TWO, expectedState);
                    this.assertRegistered(NAME_TWO);
                }
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        catch (Error e) {
            error = true;
            throw e;
        }
        finally {
            this.undeploy(mbeans2);
            if (!error) {
                this.assertNoService(NAME_ONE);
                this.assertNotRegistered(NAME_ONE);
                this.assertNoService(NAME_TWO);
                this.assertNotRegistered(NAME_TWO);
            }
        }
    }

    public void deployBrokenFirstDeployFailure(int expectedState, Class<? extends Throwable> expected) throws Exception {
        boolean error = false;
        List<ObjectName> mbeans1 = this.assertDeployFailure(this.resourceName1, NAME_ONE, expected);
        try {
            List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
            try {
                this.assertServiceState(NAME_TWO, expectedState);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            finally {
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                }
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        catch (Error e) {
            error = true;
            throw e;
        }
        finally {
            this.undeploy(mbeans1);
            if (!error) {
                this.assertNoService(NAME_ONE);
                this.assertNotRegistered(NAME_ONE);
                this.assertNoService(NAME_TWO);
                this.assertNotRegistered(NAME_TWO);
            }
        }
    }

    public void deployBrokenSecondDeployFailure(int expectedState, Class<? extends Throwable> expected) throws Exception {
        this.deployBrokenSecondDeployFailure(expectedState, expectedState, expectedState, expected);
    }

    public void deployBrokenSecondDeployFailure(int expectedState, int brokenExpectedState, Class<? extends Throwable> expected) throws Exception {
        this.deployBrokenSecondDeployFailure(expectedState, expectedState, brokenExpectedState, expected);
    }

    public void deployBrokenSecondDeployFailure(int beforeExpectedState, int afterExpectedState, int brokenExpectedState, Class<? extends Throwable> expected) throws Exception {
        boolean error = false;
        List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
        try {
            this.assertServiceState(NAME_TWO, beforeExpectedState);
            this.assertRegistered(NAME_TWO);
            List<ObjectName> mbeans1 = this.assertDeployFailure(this.resourceName1, NAME_ONE, expected);
            try {
                this.assertServiceState(NAME_TWO, afterExpectedState);
                this.assertRegistered(NAME_TWO);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            finally {
                this.undeploy(mbeans1);
                if (!error) {
                    this.assertServiceState(NAME_TWO, brokenExpectedState);
                    this.assertRegistered(NAME_TWO);
                }
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        catch (Error e) {
            error = true;
            throw e;
        }
        finally {
            this.undeploy(mbeans2);
            if (!error) {
                this.assertNoService(NAME_ONE);
                this.assertNotRegistered(NAME_ONE);
                this.assertNoService(NAME_TWO);
                this.assertNotRegistered(NAME_TWO);
            }
        }
    }

    public void deployBrokenSecondInitialDeployFailure(int expectedState, Class<? extends Throwable> expected) throws Exception {
        boolean error = false;
        List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
        try {
            this.assertServiceState(NAME_TWO, expectedState);
            this.assertRegistered(NAME_TWO);
            this.assertInitialDeployFailure(this.resourceName1, NAME_ONE, expected);
            try {
                this.assertServiceState(NAME_TWO, expectedState);
                this.assertRegistered(NAME_TWO);
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
            finally {
                if (!error) {
                    this.assertServiceState(NAME_TWO, expectedState);
                    this.assertRegistered(NAME_TWO);
                }
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        catch (Error e) {
            error = true;
            throw e;
        }
        finally {
            this.undeploy(mbeans2);
            if (!error) {
                this.assertNoService(NAME_ONE);
                this.assertNotRegistered(NAME_ONE);
                this.assertNoService(NAME_TWO);
                this.assertNotRegistered(NAME_TWO);
            }
        }
    }
}

