/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.lifecycle.seperated.test;

import java.util.List;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewOnDemandDependencyTest
extends AbstractControllerTest {
    private static ObjectName NAME_ONE = ObjectNameFactory.create((String)"test:name=1");
    private static ObjectName NAME_TWO = ObjectNameFactory.create((String)"test:name=2");
    protected String resourceName1;
    protected String resourceName2;

    public NewOnDemandDependencyTest(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return NewOnDemandDependencyTest.getNewControllerDelegate(clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeployCorrectOrder() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
        try {
            try {
                this.assertServiceInstalled(NAME_ONE);
                this.assertNotRegistered(NAME_ONE);
                this.assertNoService(NAME_TWO);
                List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
                try {
                    try {
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        test1 = this.getMBean(Simple.class, NAME_ONE, "Instance");
                        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = this.getMBean(Simple.class, NAME_TWO, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.undeploy(mbeans2);
                    if (error) throw throwable;
                    this.assertServiceRunning(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertServiceRunning(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
                }
                Object var10_13 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.undeploy(mbeans1);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)7, (int)test1.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            if (test2 == null) throw throwable;
            NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans1);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)7, (int)test1.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        if (test2 == null) return;
        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeployWrongOrder() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
        try {
            try {
                this.assertServiceConfigured(NAME_TWO);
                test2 = this.getMBean(Simple.class, NAME_TWO, "Instance");
                NewOnDemandDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.createOrder);
                NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.startOrder);
                NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
                try {
                    try {
                        this.assertServiceRunning(NAME_TWO);
                        this.assertServiceRunning(NAME_ONE);
                        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                        test1 = this.getMBean(Simple.class, NAME_ONE, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.undeploy(mbeans1);
                    if (error) throw throwable;
                    this.assertServiceDestroyed(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                    this.assertNotRegistered(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans1);
                if (!error) {
                    this.assertServiceDestroyed(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                    this.assertNotRegistered(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
                }
                Object var10_13 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.undeploy(mbeans2);
            if (error) throw throwable;
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            if (test1 == null) throw throwable;
            NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans2);
        if (error) return;
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        if (test1 == null) return;
        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRedeployOne() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
        try {
            try {
                List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
                try {
                    try {
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        test1 = this.getMBean(Simple.class, NAME_ONE, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = this.getMBean(Simple.class, NAME_TWO, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                        this.undeploy(mbeans1);
                        this.assertNotRegistered(NAME_ONE);
                        this.assertServiceDestroyed(NAME_TWO);
                        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
                        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                        mbeans1 = this.deploy(this.resourceName1);
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        test1 = this.getMBean(Simple.class, NAME_ONE, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)9, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)11, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)12, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.undeploy(mbeans2);
                    if (error) throw throwable;
                    this.assertServiceRunning(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)9, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)11, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)12, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertServiceRunning(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)9, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)11, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)12, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
                }
                Object var10_13 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.undeploy(mbeans1);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            NewOnDemandDependencyTest.assertEquals((int)9, (int)test1.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)11, (int)test1.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)15, (int)test1.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)16, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            if (test2 == null) throw throwable;
            NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)12, (int)test2.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans1);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        NewOnDemandDependencyTest.assertEquals((int)9, (int)test1.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)11, (int)test1.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)15, (int)test1.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)16, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        if (test2 == null) return;
        NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)12, (int)test2.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRedeployTwo() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
        try {
            try {
                List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
                try {
                    try {
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        test1 = this.getMBean(Simple.class, NAME_ONE, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = this.getMBean(Simple.class, NAME_TWO, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                        this.undeploy(mbeans2);
                        this.assertServiceRunning(NAME_ONE);
                        this.assertNoService(NAME_TWO);
                        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        NewOnDemandDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
                        mbeans2 = this.deploy(this.resourceName2);
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = this.getMBean(Simple.class, NAME_TWO, "Instance");
                        NewOnDemandDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.createOrder);
                        NewOnDemandDependencyTest.assertEquals((int)8, (int)test2.startOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        NewOnDemandDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.undeploy(mbeans2);
                    if (error) throw throwable;
                    this.assertServiceRunning(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)8, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertServiceRunning(NAME_ONE);
                    NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.createOrder);
                    NewOnDemandDependencyTest.assertEquals((int)8, (int)test2.startOrder);
                    NewOnDemandDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
                    NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
                }
                Object var10_13 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.undeploy(mbeans1);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)11, (int)test1.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)12, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            if (test2 == null) throw throwable;
            NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.createOrder);
            NewOnDemandDependencyTest.assertEquals((int)8, (int)test2.startOrder);
            NewOnDemandDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
            NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans1);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        NewOnDemandDependencyTest.assertEquals((int)1, (int)test1.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)3, (int)test1.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)11, (int)test1.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)12, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        if (test2 == null) return;
        NewOnDemandDependencyTest.assertEquals((int)7, (int)test2.createOrder);
        NewOnDemandDependencyTest.assertEquals((int)8, (int)test2.startOrder);
        NewOnDemandDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
        NewOnDemandDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
    }
}

