/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.controller.lifecycle.seperated.test;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.system.controller.AbstractControllerTest;
import org.jboss.test.system.controller.support.Simple;

public abstract class SeperatedDependencyTest
extends AbstractControllerTest {
    private static ObjectName NAME_ONE = ObjectNameFactory.create((String)"test:name=1");
    private static ObjectName NAME_TWO = ObjectNameFactory.create((String)"test:name=2");
    private String resourceName1;
    private String resourceName2;

    public SeperatedDependencyTest(String name) {
        super(name);
        String resourceName = ((Object)((Object)this)).getClass().getName();
        int index = resourceName.lastIndexOf(46);
        if (index != -1) {
            resourceName = resourceName.substring(index + 1, resourceName.length());
        }
        if ((index = resourceName.indexOf("NewUnitTestCase")) != -1) {
            resourceName = resourceName.substring(0, index);
        }
        if ((index = resourceName.indexOf("OldUnitTestCase")) != -1) {
            resourceName = resourceName.substring(0, index);
        }
        if (index != -1) {
            resourceName = resourceName.substring(0, index);
        }
        if ((index = resourceName.indexOf("PlainUnitTestCase")) != -1) {
            resourceName = resourceName.substring(0, index);
        }
        this.resourceName1 = resourceName + "_1.xml";
        this.resourceName2 = resourceName + "_2.xml";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeployCorrectOrder() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
        try {
            try {
                this.assertServiceRunning(NAME_ONE);
                this.assertNoService(NAME_TWO);
                MBeanServer server = this.getServer();
                test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                SeperatedDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
                try {
                    try {
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.undeploy(mbeans2);
                    if (error) throw throwable;
                    this.assertServiceRunning(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertServiceRunning(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
                }
                Object var11_14 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.undeploy(mbeans1);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
            SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
            SeperatedDependencyTest.assertEquals((int)7, (int)test1.stopOrder);
            SeperatedDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            if (test2 == null) throw throwable;
            SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
            SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
            SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
            SeperatedDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans1);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
        SeperatedDependencyTest.assertEquals((int)7, (int)test1.stopOrder);
        SeperatedDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        if (test2 == null) return;
        SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
        SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
        SeperatedDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeployWrongOrder() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
        try {
            try {
                this.assertServiceConfigured(NAME_TWO);
                MBeanServer server = this.getServer();
                test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                SeperatedDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                SeperatedDependencyTest.assertEquals((int)0, (int)test2.createOrder);
                SeperatedDependencyTest.assertEquals((int)0, (int)test2.startOrder);
                SeperatedDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                SeperatedDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
                try {
                    try {
                        this.assertServiceRunning(NAME_TWO);
                        this.assertServiceRunning(NAME_ONE);
                        SeperatedDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                        test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.undeploy(mbeans1);
                    if (error) throw throwable;
                    this.assertServiceDestroyed(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                    this.assertNotRegistered(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans1);
                if (!error) {
                    this.assertServiceDestroyed(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)2, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                    this.assertNotRegistered(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)3, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
                }
                Object var11_14 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.undeploy(mbeans2);
            if (error) throw throwable;
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            SeperatedDependencyTest.assertEquals((int)2, (int)test2.createOrder);
            SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
            SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
            SeperatedDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            if (test1 == null) throw throwable;
            SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
            SeperatedDependencyTest.assertEquals((int)3, (int)test1.startOrder);
            SeperatedDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
            SeperatedDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans2);
        if (error) return;
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        SeperatedDependencyTest.assertEquals((int)2, (int)test2.createOrder);
        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
        SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
        SeperatedDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        if (test1 == null) return;
        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
        SeperatedDependencyTest.assertEquals((int)3, (int)test1.startOrder);
        SeperatedDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
        SeperatedDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRedeployOne() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
        try {
            try {
                List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
                try {
                    try {
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        MBeanServer server = this.getServer();
                        test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                        this.undeploy(mbeans1);
                        this.assertNotRegistered(NAME_ONE);
                        this.assertServiceDestroyed(NAME_TWO);
                        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)6, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)8, (int)test1.destroyOrder);
                        SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                        mbeans1 = this.deploy(this.resourceName1);
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)9, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)11, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        SeperatedDependencyTest.assertEquals((int)10, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)12, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)7, (int)test2.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var8_11 = null;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    this.undeploy(mbeans2);
                    if (error) throw throwable;
                    this.assertServiceRunning(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)9, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)11, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)10, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)12, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertServiceRunning(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)9, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)11, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)10, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)12, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
                }
                Object var10_14 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.undeploy(mbeans1);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            SeperatedDependencyTest.assertEquals((int)9, (int)test1.createOrder);
            SeperatedDependencyTest.assertEquals((int)11, (int)test1.startOrder);
            SeperatedDependencyTest.assertEquals((int)15, (int)test1.stopOrder);
            SeperatedDependencyTest.assertEquals((int)16, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            if (test2 == null) throw throwable;
            SeperatedDependencyTest.assertEquals((int)10, (int)test2.createOrder);
            SeperatedDependencyTest.assertEquals((int)12, (int)test2.startOrder);
            SeperatedDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
            SeperatedDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans1);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        SeperatedDependencyTest.assertEquals((int)9, (int)test1.createOrder);
        SeperatedDependencyTest.assertEquals((int)11, (int)test1.startOrder);
        SeperatedDependencyTest.assertEquals((int)15, (int)test1.stopOrder);
        SeperatedDependencyTest.assertEquals((int)16, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        if (test2 == null) return;
        SeperatedDependencyTest.assertEquals((int)10, (int)test2.createOrder);
        SeperatedDependencyTest.assertEquals((int)12, (int)test2.startOrder);
        SeperatedDependencyTest.assertEquals((int)13, (int)test2.stopOrder);
        SeperatedDependencyTest.assertEquals((int)14, (int)test2.destroyOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRedeployTwo() throws Exception {
        Simple test1 = null;
        Simple test2 = null;
        boolean error = false;
        List<ObjectName> mbeans1 = this.deploy(this.resourceName1);
        try {
            try {
                List<ObjectName> mbeans2 = this.deploy(this.resourceName2);
                try {
                    try {
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        MBeanServer server = this.getServer();
                        test1 = (Simple)server.getAttribute(NAME_ONE, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test2.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                        this.undeploy(mbeans2);
                        this.assertServiceRunning(NAME_ONE);
                        this.assertNoService(NAME_TWO);
                        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        SeperatedDependencyTest.assertEquals((int)3, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)4, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)5, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)6, (int)test2.destroyOrder);
                        mbeans2 = this.deploy(this.resourceName2);
                        this.assertServiceRunning(NAME_ONE);
                        this.assertServiceRunning(NAME_TWO);
                        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                        test2 = (Simple)server.getAttribute(NAME_TWO, "Instance");
                        SeperatedDependencyTest.assertEquals((String)"()", (String)test1.constructorUsed);
                        SeperatedDependencyTest.assertEquals((int)7, (int)test2.createOrder);
                        SeperatedDependencyTest.assertEquals((int)8, (int)test2.startOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.stopOrder);
                        SeperatedDependencyTest.assertEquals((int)0, (int)test2.destroyOrder);
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    catch (Error e) {
                        error = true;
                        throw e;
                    }
                    Object var8_11 = null;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    this.undeploy(mbeans2);
                    if (error) throw throwable;
                    this.assertServiceRunning(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)7, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)8, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
                    throw throwable;
                }
                this.undeploy(mbeans2);
                if (!error) {
                    this.assertServiceRunning(NAME_ONE);
                    SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
                    SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)0, (int)test1.destroyOrder);
                    this.assertNoService(NAME_TWO);
                    this.assertNotRegistered(NAME_TWO);
                    SeperatedDependencyTest.assertEquals((int)7, (int)test2.createOrder);
                    SeperatedDependencyTest.assertEquals((int)8, (int)test2.startOrder);
                    SeperatedDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
                    SeperatedDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
                }
                Object var10_14 = null;
            }
            catch (Exception e) {
                error = true;
                throw e;
            }
            catch (Error e) {
                error = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.undeploy(mbeans1);
            if (error) throw throwable;
            this.assertNoService(NAME_ONE);
            this.assertNotRegistered(NAME_ONE);
            SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
            SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
            SeperatedDependencyTest.assertEquals((int)11, (int)test1.stopOrder);
            SeperatedDependencyTest.assertEquals((int)12, (int)test1.destroyOrder);
            this.assertNoService(NAME_TWO);
            this.assertNotRegistered(NAME_TWO);
            if (test2 == null) throw throwable;
            SeperatedDependencyTest.assertEquals((int)7, (int)test2.createOrder);
            SeperatedDependencyTest.assertEquals((int)8, (int)test2.startOrder);
            SeperatedDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
            SeperatedDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
            throw throwable;
        }
        this.undeploy(mbeans1);
        if (error) return;
        this.assertNoService(NAME_ONE);
        this.assertNotRegistered(NAME_ONE);
        SeperatedDependencyTest.assertEquals((int)1, (int)test1.createOrder);
        SeperatedDependencyTest.assertEquals((int)2, (int)test1.startOrder);
        SeperatedDependencyTest.assertEquals((int)11, (int)test1.stopOrder);
        SeperatedDependencyTest.assertEquals((int)12, (int)test1.destroyOrder);
        this.assertNoService(NAME_TWO);
        this.assertNotRegistered(NAME_TWO);
        if (test2 == null) return;
        SeperatedDependencyTest.assertEquals((int)7, (int)test2.createOrder);
        SeperatedDependencyTest.assertEquals((int)8, (int)test2.startOrder);
        SeperatedDependencyTest.assertEquals((int)9, (int)test2.stopOrder);
        SeperatedDependencyTest.assertEquals((int)10, (int)test2.destroyOrder);
    }
}

