/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.metadata.attributes.test;

import java.util.List;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.test.system.metadata.attributes.test.AbstractAttributeTest;

public class AttributeUnitTestCase
extends AbstractAttributeTest {
    public AttributeUnitTestCase(String name) {
        super(name);
    }

    public void testAttributeNone() throws Exception {
        this.noAttributes();
    }

    public void testAttributeOne() throws Exception {
        ServiceAttributeMetaData attribute = this.unmarshallSingleAttribute();
        this.assertTextAttribute(attribute);
    }

    public void testAttributeTwo() throws Exception {
        List<ServiceAttributeMetaData> attributes = this.unmarshallMultipleAttributes(2);
        ServiceAttributeMetaData test = attributes.get(0);
        this.assertTextAttribute(test, "Attribute1", "value1");
        test = attributes.get(1);
        this.assertTextAttribute(test, "Attribute2", "value2");
    }

    public void testAttributeNoValue() throws Exception {
        this.noAttributes();
    }

    public void testAttributeEmptyValue() throws Exception {
        this.noAttributes();
    }

    public void testAttributeNoTrim() throws Exception {
        ServiceAttributeMetaData attribute = this.unmarshallSingleAttribute();
        this.assertTextAttribute(attribute, false, true);
    }

    public void testAttributeNoReplace() throws Exception {
        ServiceAttributeMetaData attribute = this.unmarshallSingleAttribute();
        this.assertTextAttribute(attribute, true, false);
    }

    protected void assertOthers(ServiceMetaData metaData) throws Exception {
        super.assertOthers(metaData);
        this.assertNoDependencies(metaData);
    }
}

