/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.metadata.basic.test;

import javax.management.MalformedObjectNameException;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.test.system.metadata.test.AbstractMetaDataTest;

public class BasicMBeanUnitTestCase
extends AbstractMetaDataTest {
    public BasicMBeanUnitTestCase(String name) {
        super(name);
    }

    public void testBasicMBean() throws Exception {
        ServiceMetaData metaData = this.unmarshalSingleMBean();
        BasicMBeanUnitTestCase.assertEquals((Object)testBasicMBeanName, (Object)metaData.getObjectName());
        BasicMBeanUnitTestCase.assertEquals((String)testBasicMBeanCode, (String)metaData.getCode());
        BasicMBeanUnitTestCase.assertNull((Object)metaData.getInterfaceName());
        BasicMBeanUnitTestCase.assertNull((Object)metaData.getMode());
        this.assertOthers(metaData);
    }

    public void testBasicMBeanNoName() throws Exception {
        this.assertFailUnmarshal(RuntimeException.class);
    }

    public void testBasicMBeanEmptyName() throws Exception {
        this.assertFailUnmarshal(RuntimeException.class);
    }

    public void testBasicMBeanInvalidName() throws Exception {
        this.assertFailUnmarshal(MalformedObjectNameException.class);
    }

    public void testBasicMBeanInterface() throws Exception {
        ServiceMetaData metaData = this.unmarshalSingleMBean();
        BasicMBeanUnitTestCase.assertEquals((Object)testBasicMBeanName, (Object)metaData.getObjectName());
        BasicMBeanUnitTestCase.assertEquals((String)testBasicMBeanCode, (String)metaData.getCode());
        BasicMBeanUnitTestCase.assertEquals((String)testBasicMBeanInterface, (String)metaData.getInterfaceName());
        BasicMBeanUnitTestCase.assertNull((Object)metaData.getMode());
        this.assertOthers(metaData);
    }

    public void testBasicMBeanMode() throws Exception {
        ServiceMetaData metaData = this.unmarshalSingleMBean();
        BasicMBeanUnitTestCase.assertEquals((Object)testBasicMBeanName, (Object)metaData.getObjectName());
        BasicMBeanUnitTestCase.assertEquals((String)testBasicMBeanCode, (String)metaData.getCode());
        BasicMBeanUnitTestCase.assertEquals((Object)ControllerMode.ON_DEMAND, (Object)metaData.getMode());
        this.assertOthers(metaData);
    }

    protected void assertOthers(ServiceMetaData metaData) throws Exception {
        this.assertDefaultConstructor(metaData);
        this.assertNoAttributes(metaData);
        this.assertNoDependencies(metaData);
        this.assertNoXMBean(metaData);
    }
}

