/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.metadata.constructor.test;

import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.test.system.metadata.test.AbstractMetaDataTest;

public class ConstructorUnitTestCase
extends AbstractMetaDataTest {
    public ConstructorUnitTestCase(String name) {
        super(name);
    }

    public void testConstructorDefault() throws Exception {
        ServiceMetaData metaData = this.unmarshalSingleMBean();
        this.assertDefaultConstructor(metaData);
        this.assertOthers(metaData);
    }

    public void testConstructorOneArg() throws Exception {
        ServiceMetaData metaData = this.unmarshalSingleMBean();
        String[] expectedSignature = new String[]{"signature1"};
        String[] expectedParams = new String[]{"param1"};
        this.assertConstructor(expectedSignature, expectedParams, metaData);
        this.assertOthers(metaData);
    }

    public void testConstructorTwoArgs() throws Exception {
        ServiceMetaData metaData = this.unmarshalSingleMBean();
        String[] expectedSignature = new String[]{"signature1", "signature2"};
        String[] expectedParams = new String[]{"param1", "param2"};
        this.assertConstructor(expectedSignature, expectedParams, metaData);
        this.assertOthers(metaData);
    }

    public void testConstructorEmptyValue() throws Exception {
        ServiceMetaData metaData = this.unmarshalSingleMBean();
        String[] expectedSignature = new String[]{"signature1"};
        String[] expectedParams = new String[]{""};
        this.assertConstructor(expectedSignature, expectedParams, metaData);
        this.assertOthers(metaData);
    }

    protected void assertOthers(ServiceMetaData metaData) throws Exception {
        ConstructorUnitTestCase.assertEquals((Object)testBasicMBeanName, (Object)metaData.getObjectName());
        ConstructorUnitTestCase.assertEquals((String)testBasicMBeanCode, (String)metaData.getCode());
        ConstructorUnitTestCase.assertNull((Object)metaData.getInterfaceName());
        this.assertNoAttributes(metaData);
        this.assertNoDependencies(metaData);
        this.assertNoXMBean(metaData);
    }
}

