/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.metadata.test;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.management.ObjectName;
import junit.framework.AssertionFailedError;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyListValueMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceElementValueMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceJBXBValueMetaData;
import org.jboss.system.metadata.ServiceJavaBeanValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueFactoryParameterMetaData;
import org.jboss.system.metadata.ServiceValueFactoryValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.test.AbstractSystemTest;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.system.metadata.test.MetaDataTestDelegate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMetaDataTest
extends AbstractSystemTest {
    protected static ObjectName testBasicMBeanName = ObjectNameFactory.create((String)"jboss.test:type=BasicMBeanName");
    protected static String testBasicMBeanCode = "BasicMBeanCode";
    protected static String testBasicMBeanInterface = "BasicMBeanInterface";
    protected static ObjectName TEST1 = ObjectNameFactory.create((String)"test:test=1");
    protected static ObjectName TEST2 = ObjectNameFactory.create((String)"test:test=2");
    protected static ObjectName[] NO_OBJECT_NAMES = new ObjectName[0];

    public AbstractMetaDataTest(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        MetaDataTestDelegate delegate = new MetaDataTestDelegate(clazz);
        delegate.enableSecurity = true;
        return delegate;
    }

    protected List<ServiceMetaData> unmarshal(String name) throws Exception {
        URL url = this.findXML(name);
        return this.getMetaDataDelegate().unmarshal(url);
    }

    protected ServiceMetaData unmarshalSingleMBean() throws Exception {
        String name = this.getName();
        name = name.substring(4) + ".xml";
        return this.unmarshalSingleMBean(name);
    }

    protected ServiceMetaData unmarshalSingleMBean(String name) throws Exception {
        URL url = this.findXML(name);
        List<ServiceMetaData> services = this.getMetaDataDelegate().unmarshal(url);
        AbstractMetaDataTest.assertFalse((String)(url + " should contain an mbean "), (boolean)services.isEmpty());
        ServiceMetaData service = services.get(services.size() - 1);
        AbstractMetaDataTest.assertNotNull((Object)service);
        return service;
    }

    protected void assertFailUnmarshal(Class<? extends Throwable> expected) throws Exception {
        String name = this.getName();
        name = name.substring(4) + ".xml";
        this.assertFailUnmarshal(name, expected);
    }

    protected void assertFailUnmarshal(String name, Class<? extends Throwable> expected) throws Exception {
        try {
            this.unmarshal(name);
            AbstractMetaDataTest.fail((String)("Should fail to unmarshal " + name));
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable error) {
            AbstractSystemTest.checkThrowableDeep(expected, error);
        }
    }

    protected URL findXML(String name) throws Exception {
        URL url = this.getResource(name);
        if (url == null) {
            throw new IOException(name + " not found");
        }
        return url;
    }

    protected MetaDataTestDelegate getMetaDataDelegate() {
        return (MetaDataTestDelegate)this.getDelegate();
    }

    protected void assertDefaultConstructor(ServiceMetaData metaData) throws Exception {
        ServiceConstructorMetaData constructor = metaData.getConstructor();
        AbstractMetaDataTest.assertNotNull((Object)constructor);
        String[] signature = constructor.getSignature();
        AbstractMetaDataTest.assertNotNull((Object)signature);
        AbstractMetaDataTest.assertEquals((int)0, (int)signature.length);
        String[] params = constructor.getParams();
        AbstractMetaDataTest.assertNotNull((Object)params);
        AbstractMetaDataTest.assertEquals((int)0, (int)params.length);
    }

    protected void assertConstructor(String[] expectedSignature, String[] expectedParams, ServiceMetaData metaData) throws Exception {
        ServiceConstructorMetaData constructor = metaData.getConstructor();
        AbstractMetaDataTest.assertNotNull((Object)constructor);
        Object[] signature = constructor.getSignature();
        AbstractMetaDataTest.assertNotNull((Object)signature);
        this.assertEquals(expectedSignature, signature);
        Object[] params = constructor.getParams();
        AbstractMetaDataTest.assertNotNull((Object)params);
        this.assertEquals(expectedParams, params);
    }

    protected void assertNoAttributes(ServiceMetaData metaData) throws Exception {
        List attributes = metaData.getAttributes();
        AbstractMetaDataTest.assertNotNull((Object)attributes);
        AbstractMetaDataTest.assertEquals((int)0, (int)attributes.size());
    }

    protected void assertAttributeName(ServiceAttributeMetaData attribute, String name) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)attribute);
        String result = attribute.getName();
        AbstractMetaDataTest.assertNotNull((Object)result);
        AbstractMetaDataTest.assertEquals((String)("Expected attribute with name " + name + " got " + result), (String)name, (String)result);
    }

    protected void assertAttribute(ServiceMetaData metaData, String name) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        List attributes = metaData.getAttributes();
        AbstractMetaDataTest.assertNotNull((Object)attributes);
        AbstractMetaDataTest.assertEquals((int)1, (int)attributes.size());
        ServiceAttributeMetaData attribute = (ServiceAttributeMetaData)attributes.get(0);
        this.assertAttributeName(attribute, name);
    }

    protected void assertAttributes(ServiceMetaData metaData, String[] names) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)names);
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        List attributes = metaData.getAttributes();
        AbstractMetaDataTest.assertNotNull((Object)attributes);
        AbstractMetaDataTest.assertEquals((int)names.length, (int)attributes.size());
        ServiceAttributeMetaData attribute = (ServiceAttributeMetaData)attributes.get(0);
        for (String name : names) {
            this.assertAttributeName(attribute, name);
        }
    }

    protected void assertAttribute(ServiceAttributeMetaData attribute, boolean trim, boolean replace, String name) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)attribute);
        String result = attribute.getName();
        AbstractMetaDataTest.assertNotNull((Object)result);
        AbstractMetaDataTest.assertEquals((String)name, (String)result);
        AbstractMetaDataTest.assertEquals((boolean)trim, (boolean)attribute.isTrim());
        AbstractMetaDataTest.assertEquals((boolean)replace, (boolean)attribute.isReplace());
    }

    protected void assertTextAttribute(ServiceAttributeMetaData attribute) throws Exception {
        this.assertTextAttribute(attribute, true, true, "Attribute", "value");
    }

    protected void assertTextAttribute(ServiceAttributeMetaData attribute, String value) throws Exception {
        this.assertTextAttribute(attribute, true, true, "Attribute", value);
    }

    protected void assertTextAttribute(ServiceAttributeMetaData attribute, String name, String value) throws Exception {
        this.assertTextAttribute(attribute, true, true, name, value);
    }

    protected void assertTextAttribute(ServiceAttributeMetaData attribute, boolean trim, boolean replace) throws Exception {
        this.assertTextAttribute(attribute, trim, replace, "Attribute", "value");
    }

    protected void assertTextAttribute(ServiceAttributeMetaData attribute, boolean trim, boolean replace, String name, String value) throws Exception {
        this.assertAttribute(attribute, trim, replace, name);
        ServiceValueMetaData actual = attribute.getValue();
        AbstractMetaDataTest.assertNotNull((Object)actual);
        this.assertTextValue(actual, value);
    }

    protected void assertDependsAttribute(ServiceAttributeMetaData attribute) throws Exception {
        this.assertDependsAttribute(attribute, false, false, "Attribute", TEST1);
    }

    protected void assertDependsAttribute(ServiceAttributeMetaData attribute, String name, ObjectName value) throws Exception {
        this.assertDependsAttribute(attribute, false, false, name, value);
    }

    protected void assertDependsAttribute(ServiceAttributeMetaData attribute, boolean trim, boolean replace, String name, ObjectName value) throws Exception {
        this.assertAttribute(attribute, trim, replace, name);
        ServiceValueMetaData actual = attribute.getValue();
        AbstractMetaDataTest.assertNotNull((Object)actual);
        this.assertDependencyValue(actual, value);
    }

    protected void assertDependsListAttribute(ServiceAttributeMetaData attribute) throws Exception {
        this.assertDependsListAttribute(attribute, false, false, "Attribute", TEST1);
    }

    protected void assertDependsListAttribute(ServiceAttributeMetaData attribute, String name, ObjectName value) throws Exception {
        this.assertDependsListAttribute(attribute, false, false, name, value);
    }

    protected void assertDependsListAttribute(ServiceAttributeMetaData attribute, boolean trim, boolean replace, String name, ObjectName value) throws Exception {
        this.assertDependsListAttribute(attribute, trim, replace, name, new ObjectName[]{value});
    }

    protected void assertDependsListAttribute(ServiceAttributeMetaData attribute, boolean trim, boolean replace, String name, ObjectName[] value) throws Exception {
        this.assertAttribute(attribute, trim, replace, name);
        ServiceValueMetaData actual = attribute.getValue();
        AbstractMetaDataTest.assertNotNull((Object)actual);
        this.assertDependencyListValue(actual, value);
    }

    protected void assertDependsListAttributeEmpty(ServiceAttributeMetaData attribute) throws Exception {
        this.assertDependsListAttribute(attribute, false, false, "Attribute", NO_OBJECT_NAMES);
    }

    protected void assertTextValue(ServiceValueMetaData actual, String expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)expected);
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceTextValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceTextValueMetaData.class, actual);
        AbstractMetaDataTest.assertEquals((String)expected, (String)value.getText());
    }

    protected void assertDependencyValue(ServiceValueMetaData actual, ObjectName expected) throws Exception {
        this.assertDependencyValue(actual, expected, null);
    }

    protected void assertDependencyValue(ServiceValueMetaData actual, ObjectName expected, String proxyType) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)expected);
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceDependencyValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceDependencyValueMetaData.class, actual);
        AbstractMetaDataTest.assertEquals((Object)expected, (Object)value.getObjectName());
        AbstractMetaDataTest.assertEquals((String)proxyType, (String)value.getProxyType());
    }

    protected void assertDependencyListValueEmpty(ServiceValueMetaData actual) throws Exception {
        this.assertDependencyListValue(actual, NO_OBJECT_NAMES);
    }

    protected void assertDependencyListValue(ServiceValueMetaData actual, ObjectName expected) throws Exception {
        this.assertDependencyListValue(actual, new ObjectName[]{expected});
    }

    protected void assertDependencyListValue(ServiceValueMetaData actual, ObjectName[] expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)expected);
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceDependencyListValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceDependencyListValueMetaData.class, actual);
        List list = value.getObjectNames();
        AbstractMetaDataTest.assertNotNull((Object)list);
        Object[] test = list.toArray(new ObjectName[list.size()]);
        AbstractMetaDataTest.assertTrue((String)("Expected " + Arrays.asList(expected) + " got " + Arrays.asList(test)), (boolean)Arrays.equals(expected, test));
    }

    protected void assertElementValue(ServiceValueMetaData actual, String expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)expected);
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceElementValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceElementValueMetaData.class, actual);
        Element element = value.getElement();
        AbstractMetaDataTest.assertNotNull((Object)element);
        String name = element.getTagName();
        AbstractMetaDataTest.assertNotNull((Object)name);
        AbstractMetaDataTest.assertEquals((String)expected, (String)name);
    }

    protected void assertJavaBeanValue(ServiceValueMetaData actual, String expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceJavaBeanValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceJavaBeanValueMetaData.class, actual);
        Element element = value.getElement();
        this.assertChildOfAttribute(element, expected);
    }

    protected void assertJBXBValue(ServiceValueMetaData actual, String expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceJBXBValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceJBXBValueMetaData.class, actual);
        Element element = value.getElement();
        this.assertChildOfAttribute(element, expected);
    }

    protected void assertInjectValue(ServiceValueMetaData actual, Object dependency, String property) throws Exception {
        this.assertInjectValue(actual, dependency, property, ControllerState.INSTALLED);
    }

    protected void assertInjectValue(ServiceValueMetaData actual, Object dependency, String property, ControllerState requiredState) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceInjectionValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceInjectionValueMetaData.class, actual);
        AbstractMetaDataTest.assertEquals((Object)dependency, (Object)value.getDependency());
        AbstractMetaDataTest.assertEquals((String)property, (String)value.getProperty());
        AbstractMetaDataTest.assertEquals((Object)requiredState, (Object)value.getDependentState());
    }

    protected void assertValueFactoryValue(ServiceValueMetaData actual, List<ServiceValueFactoryParameterMetaData> parameters, String defaultValue) throws Exception {
        this.assertValueFactoryValue(actual, "method", parameters, defaultValue, "bean", ControllerState.INSTALLED);
    }

    protected void assertValueFactoryValue(ServiceValueMetaData actual, List<ServiceValueFactoryParameterMetaData> parameters, String defaultValue, ControllerState state) throws Exception {
        this.assertValueFactoryValue(actual, "method", parameters, defaultValue, "bean", state);
    }

    protected void assertValueFactoryValue(ServiceValueMetaData actual, String method, List<ServiceValueFactoryParameterMetaData> parameters, String defaultValue, Object dependency, ControllerState requiredState) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)actual);
        ServiceValueFactoryValueMetaData value = AbstractMetaDataTest.assertInstanceOf(ServiceValueFactoryValueMetaData.class, actual);
        AbstractMetaDataTest.assertEquals((String)method, (String)value.getMethod());
        AbstractMetaDataTest.assertEquals((Object)dependency, (Object)value.getDependency());
        AbstractMetaDataTest.assertEquals((Object)requiredState, (Object)value.getDependentState());
        ServiceTextValueMetaData defMetadata = value.getDefaultValue();
        AbstractMetaDataTest.assertEquals((String)defaultValue, (String)(defMetadata == null ? null : defMetadata.getText()));
        AbstractMetaDataTest.assertEquals(parameters, (Object)value.getParameterMetaData());
    }

    protected void assertChildOfAttribute(Element element, String expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)element);
        String name = element.getTagName();
        AbstractMetaDataTest.assertEquals((String)"attribute", (String)name);
        NodeList children = element.getChildNodes();
        AbstractMetaDataTest.assertEquals((int)1, (int)children.getLength());
        Node node = children.item(0);
        element = AbstractMetaDataTest.assertInstanceOf(Element.class, node);
        name = element.getTagName();
        AbstractMetaDataTest.assertEquals((String)expected, (String)name);
    }

    protected void assertNoDependencies(ServiceMetaData metaData) throws Exception {
        List dependencies = metaData.getDependencies();
        AbstractMetaDataTest.assertNotNull((Object)dependencies);
        AbstractMetaDataTest.assertEquals((int)0, (int)dependencies.size());
    }

    protected void assertDependencies(ServiceMetaData metaData, ObjectName[] expected) throws Exception {
        List dependencies = metaData.getDependencies();
        AbstractMetaDataTest.assertNotNull((Object)dependencies);
        AbstractMetaDataTest.assertEquals((int)expected.length, (int)dependencies.size());
        HashSet<ObjectName> expectedSet = new HashSet<ObjectName>();
        for (ObjectName expect : expected) {
            expectedSet.add(expect);
        }
        HashSet<ObjectName> actual = new HashSet<ObjectName>();
        for (ServiceDependencyMetaData depends : dependencies) {
            actual.add(depends.getIDependOnObjectName());
        }
        AbstractMetaDataTest.assertEquals(expectedSet, actual);
    }

    protected void assertNoXMBean(ServiceMetaData metaData) throws Exception {
        AbstractMetaDataTest.assertNull((Object)metaData.getXMBeanDD());
        AbstractMetaDataTest.assertEquals((String)"org.jboss.mx.modelmbean.XMBean", (String)metaData.getXMBeanCode());
        AbstractMetaDataTest.assertNull((Object)metaData.getXMBeanDescriptor());
    }
}

