/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.metadata.value.valuefactory.test;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import junit.framework.TestCase;
import org.jboss.system.metadata.ServiceValueFactoryParameterMetaData;
import org.jboss.util.propertyeditor.ElementEditor;
import org.w3c.dom.Element;

public class ServiceValueFactoryParameterMetaDataUnitTestCase
extends TestCase {
    private static final String ONE = "1";
    private static final String TRUE = "TRUE";
    private static final String BOOL = "boolean";
    private static final String BOOLEAN = "java.lang.Boolean";
    private static final String INT = "int";
    private static final String INTEGER = "java.lang.Integer";
    private static final String STRING = "java.lang.String";
    private static final String HASH_MAP = "java.util.HashMap";
    private static final String ATTR = "Attr";
    private static final String ELEMENT = Element.class.getName();
    private static final String ELEMENT_ATTR = "<element/>";
    private PropertyEditor existingElementEditor;

    public ServiceValueFactoryParameterMetaDataUnitTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.existingElementEditor = PropertyEditorManager.findEditor(Element.class);
        if (this.existingElementEditor == null) {
            PropertyEditorManager.registerEditor(Element.class, ElementEditor.class);
        }
    }

    protected void tearDown() throws Exception {
        if (this.existingElementEditor == null) {
            PropertyEditorManager.registerEditor(Element.class, null);
        }
        super.tearDown();
    }

    public void testGetValueNull() throws Exception {
        ServiceValueFactoryParameterMetaDataUnitTestCase.assertNull((Object)ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), null, (String)STRING, (String)ATTR));
    }

    public void testGetValueInt() throws Exception {
        ServiceValueFactoryParameterMetaDataUnitTestCase.assertEquals((Object)1, (Object)ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)ONE, (String)INT, (String)ATTR));
    }

    public void testGetValueInteger() throws Exception {
        ServiceValueFactoryParameterMetaDataUnitTestCase.assertEquals((Object)new Integer(1), (Object)ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)ONE, (String)INTEGER, (String)ATTR));
    }

    public void testGetValueBool() throws Exception {
        ServiceValueFactoryParameterMetaDataUnitTestCase.assertEquals((Object)true, (Object)ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)TRUE, (String)BOOL, (String)ATTR));
    }

    public void testGetValueBoolean() throws Exception {
        ServiceValueFactoryParameterMetaDataUnitTestCase.assertEquals((Object)Boolean.TRUE, (Object)ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)TRUE, (String)BOOLEAN, (String)ATTR));
    }

    public void testGetValueString() throws Exception {
        ServiceValueFactoryParameterMetaDataUnitTestCase.assertEquals((Object)ONE, (Object)ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)ONE, (String)STRING, (String)ATTR));
    }

    public void testGetValueElement() throws Exception {
        Element result = (Element)ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)ELEMENT_ATTR, (String)ELEMENT, (String)ATTR);
        ServiceValueFactoryParameterMetaDataUnitTestCase.assertEquals((String)"element", (String)result.getNodeName());
    }

    public void testGetValueNoPropertyEditor() {
        try {
            ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)ONE, (String)HASH_MAP, (String)ATTR);
            ServiceValueFactoryParameterMetaDataUnitTestCase.fail((String)"Should not have a property editor for HashMap");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetValueUnknownType() {
        try {
            ServiceValueFactoryParameterMetaData.getValue((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)ONE, (String)"com.foo.Bar", (String)ATTR);
            ServiceValueFactoryParameterMetaDataUnitTestCase.fail((String)"Should not succeed with bogus type");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

