/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.metadata.value.valuefactory.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.system.metadata.ServiceValueFactoryParameterMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.test.system.metadata.value.AbstractValueTest;

public class ValueFactoryParsingUnitTestCase
extends AbstractValueTest {
    private static final String PARAMETER = "parameter";
    private static final String DEFAULT = "default";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String NUMBER = "java.lang.Number";
    private static final String INTEGER = "java.lang.Integer";
    private static final String LONG = "java.lang.Long";
    private static final ServiceValueFactoryParameterMetaData PARAMETER_MD = new ServiceValueFactoryParameterMetaData("parameter", null, null);
    private static final List<ServiceValueFactoryParameterMetaData> SIMPLE_LIST = Arrays.asList(PARAMETER_MD);
    private static final String UNFIXED = " ${valuefactory.test.property:1} ";

    public ValueFactoryParsingUnitTestCase(String name) {
        super(name);
    }

    public void testBasicValueFactory() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        this.assertValueFactoryValue(value, SIMPLE_LIST, DEFAULT);
    }

    public void testMinimal() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        this.assertValueFactoryValue(value, Collections.EMPTY_LIST, null);
    }

    public void testNestedBean() throws Exception {
        try {
            this.unmarshallSingleValue();
            ValueFactoryParsingUnitTestCase.fail((String)"Should not be able to handle a nested bean element");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNoDefault() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        this.assertValueFactoryValue(value, SIMPLE_LIST, null);
    }

    public void testNoParameter() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        this.assertValueFactoryValue(value, Collections.EMPTY_LIST, DEFAULT);
    }

    public void testNullParameter() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(null, null, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, null, null);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }

    public void testElementParameter() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData("<element/>", null, null);
        this.assertValueFactoryValue(value, Arrays.asList(one), DEFAULT);
    }

    public void testState() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        this.assertValueFactoryValue(value, SIMPLE_LIST, DEFAULT, ControllerState.CREATE);
    }

    public void testTypedParameters() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, INTEGER, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, LONG, null);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }

    public void testTypedParametersWithValue() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, INTEGER, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, NUMBER, LONG);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }

    public void testUntypedParameters() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, null, null);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }

    public void testUntypedParametersWithValue() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, null, LONG);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }

    public void testTrimAndReplace() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(UNFIXED, null, null);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }

    public void testTrimAndReplaceWithValue() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null, INTEGER);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(UNFIXED, null, null);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }

    public void testTrimAndReplaceWithValueAndOverride() throws Exception {
        ServiceValueMetaData value = this.unmarshallSingleValue();
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null, INTEGER);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(ONE, null, null);
        this.assertValueFactoryValue(value, Arrays.asList(one, two), DEFAULT);
    }
}

