/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.system.metadata.value.valuefactory.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.system.metadata.ServiceValueFactoryParameterMetaData;
import org.jboss.system.metadata.ServiceValueFactoryValueMetaData;
import org.jboss.test.system.metadata.value.valuefactory.test.MockMethodInfo;
import org.jboss.test.system.metadata.value.valuefactory.test.MockTypeInfo;

public class ValueFactoryTypeAnalysisUnitTestCase
extends TestCase {
    private static final String METHOD = "method";
    private static final String OTHER_METHOD = "other";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String INTEGER = "java.lang.Integer";
    private static final String LONG = "java.lang.Long";
    private static final TypeInfo OBJECT_TYPE = new MockTypeInfo(Object.class);
    private static final TypeInfo STRING_TYPE = new MockTypeInfo(String.class);
    private static final TypeInfo INTEGER_TYPE = new MockTypeInfo(Integer.class);
    private static final TypeInfo LONG_TYPE = new MockTypeInfo(Long.class);
    private Set<MethodInfo> allMethods = new HashSet<MethodInfo>();

    public ValueFactoryTypeAnalysisUnitTestCase(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.allMethods.clear();
        super.tearDown();
    }

    public void testNoArgsMatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[0]);
        this.allMethods.add(mi);
        ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, (List)Collections.EMPTY_LIST);
    }

    public void testFullySpecifiedMatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, LONG_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, INTEGER);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, LONG);
        ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one, two));
        ValueFactoryTypeAnalysisUnitTestCase.assertEquals((String)INTEGER, (String)one.getParameterTypeName());
        ValueFactoryTypeAnalysisUnitTestCase.assertEquals((String)LONG, (String)two.getParameterTypeName());
    }

    public void testPartialMatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, LONG_TYPE});
        this.allMethods.add(mi);
        mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, LONG);
        ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one, two));
        ValueFactoryTypeAnalysisUnitTestCase.assertEquals((String)INTEGER, (String)one.getParameterTypeName());
        ValueFactoryTypeAnalysisUnitTestCase.assertEquals((String)LONG, (String)two.getParameterTypeName());
    }

    public void testUnpecifiedMatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, LONG_TYPE});
        this.allMethods.add(mi);
        mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, null);
        ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one, two));
        ValueFactoryTypeAnalysisUnitTestCase.assertEquals((String)INTEGER, (String)one.getParameterTypeName());
        ValueFactoryTypeAnalysisUnitTestCase.assertEquals((String)LONG, (String)two.getParameterTypeName());
    }

    public void testFullySpecifiedMismatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, INTEGER_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, INTEGER);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, LONG);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one, two));
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException good) {
            // empty catch block
        }
    }

    public void testPartialMismatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, INTEGER_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, LONG);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one, two));
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException good) {
            // empty catch block
        }
    }

    public void testNameMismatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[0]);
        this.allMethods.add(mi);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)OTHER_METHOD, (List)Collections.EMPTY_LIST);
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testZeroParamsToOneParam() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[0]);
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one));
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testOneParamToZeroParams() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{OBJECT_TYPE});
        this.allMethods.add(mi);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, (List)Collections.EMPTY_LIST);
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTwoParamsToOneParam() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, LONG_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, INTEGER);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one));
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testOneParamToTwoParams() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, INTEGER);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, INTEGER);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one, two));
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException good) {
            // empty catch block
        }
    }

    public void testDoubleMatch() {
        MockMethodInfo mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, LONG_TYPE});
        this.allMethods.add(mi);
        mi = new MockMethodInfo(METHOD, new TypeInfo[]{INTEGER_TYPE, STRING_TYPE});
        this.allMethods.add(mi);
        ServiceValueFactoryParameterMetaData one = new ServiceValueFactoryParameterMetaData(ONE, null);
        ServiceValueFactoryParameterMetaData two = new ServiceValueFactoryParameterMetaData(TWO, null);
        try {
            ServiceValueFactoryValueMetaData.populateParameterTypes(this.allMethods, (String)METHOD, Arrays.asList(one, two));
            ValueFactoryTypeAnalysisUnitTestCase.fail((String)"Should have thrown exception due to mismatch");
        }
        catch (IllegalArgumentException good) {
            // empty catch block
        }
    }
}

