/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.plugins.ScopedController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.api.dependency.Matcher;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.event.AbstractEventEmitter;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractKernelController
extends ScopedController
implements KernelController,
KernelRegistryPlugin {
    protected Kernel kernel;
    protected AbstractEventEmitter emitterDelegate = this.createEventEmitter();
    protected Map<Object, List<KernelControllerContext>> suppliers = new ConcurrentHashMap<Object, List<KernelControllerContext>>();
    protected Map<Class<?>, ClassContext> contextsByClass = new ConcurrentHashMap();

    protected AbstractEventEmitter createEventEmitter() {
        return new AbstractEventEmitter();
    }

    public KernelControllerContext install(BeanMetaData metaData) throws Throwable {
        return this.install(metaData, null);
    }

    public KernelControllerContext install(BeanMetaData metaData, Object target) throws Throwable {
        AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, metaData, target);
        this.install((ControllerContext)context);
        return context;
    }

    public KernelRegistryEntry getEntry(Object name) {
        List<KernelControllerContext> list = name instanceof Matcher ? this.matchSupplies((Matcher)name) : this.suppliers.get(name);
        if (list != null && !list.isEmpty()) {
            return (KernelRegistryEntry)list.get(0);
        }
        if (name instanceof Class) {
            return this.getContextByClass((Class)name);
        }
        return null;
    }

    protected List<KernelControllerContext> matchSupplies(Matcher matcher) {
        for (Map.Entry<Object, List<KernelControllerContext>> entry : this.suppliers.entrySet()) {
            if (!matcher.match(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public ControllerContext getContext(Object name, ControllerState state) {
        ControllerContext context = super.getContext(name, state);
        if (context != null) {
            return context;
        }
        if (state == null || ControllerState.INSTALLED.equals((Object)state)) {
            KernelRegistry registry = this.kernel.getRegistry();
            try {
                return registry.getEntry(name);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSupplies(KernelControllerContext context) {
        BeanMetaData metaData = context.getBeanMetaData();
        Set supplies = metaData.getSupplies();
        if (supplies != null) {
            boolean trace = this.log.isTraceEnabled();
            if (!supplies.isEmpty()) {
                this.lockWrite();
                try {
                    for (SupplyMetaData supplied : supplies) {
                        Object supply = supplied.getSupply();
                        List<KernelControllerContext> list = this.suppliers.get(supply);
                        if (list == null) {
                            list = new CopyOnWriteArrayList<KernelControllerContext>();
                            this.suppliers.put(supply, list);
                        }
                        list.add(context);
                        if (!trace) continue;
                        this.log.trace((Object)("Suppliers of " + supply + ": " + list));
                    }
                }
                finally {
                    this.unlockWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSupplies(KernelControllerContext context) {
        BeanMetaData metaData = context.getBeanMetaData();
        Set supplies = metaData.getSupplies();
        if (supplies != null) {
            boolean trace = this.log.isTraceEnabled();
            if (!supplies.isEmpty()) {
                this.lockWrite();
                try {
                    for (SupplyMetaData supplied : supplies) {
                        Object supply = supplied.getSupply();
                        List<KernelControllerContext> list = this.suppliers.get(supply);
                        if (list == null) continue;
                        list.remove(context);
                        if (list.isEmpty()) {
                            this.suppliers.remove(supply);
                        }
                        if (!trace) continue;
                        this.log.trace((Object)("Suppliers of " + supply + ": " + list));
                    }
                }
                finally {
                    this.unlockWrite();
                }
            }
        }
    }

    public Kernel getKernel() {
        Kernel.checkAccess();
        return this.kernel;
    }

    public void setKernel(Kernel kernel) throws Throwable {
        Kernel.checkConfigure();
        this.kernel = kernel;
    }

    public void fireKernelEvent(KernelEvent event) {
        this.emitterDelegate.fireKernelEvent(event);
    }

    public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        this.emitterDelegate.registerListener(listener, filter, handback);
    }

    public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        this.emitterDelegate.unregisterListener(listener, filter, handback);
    }

    protected Set<KernelControllerContext> getContexts(Class<?> clazz) {
        ClassContext classContext = this.contextsByClass.get(clazz);
        if (classContext != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Marking class " + clazz + " as used."));
            }
            classContext.used = true;
            return classContext.contexts;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KernelControllerContext> getInstantiatedContexts(Class<?> clazz) {
        this.lockRead();
        try {
            Set<KernelControllerContext> contexts = this.getContexts(clazz);
            Set<KernelControllerContext> set = contexts != null && !contexts.isEmpty() ? Collections.unmodifiableSet(contexts) : null;
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KernelControllerContext> getContexts(Class<?> clazz, ControllerState state) {
        this.lockRead();
        try {
            Set<KernelControllerContext> contexts = this.getContexts(clazz);
            if (contexts != null && !contexts.isEmpty()) {
                HashSet<KernelControllerContext> kccs = new HashSet<KernelControllerContext>();
                List states = this.getStates();
                int stateIndex = states.indexOf(state);
                for (KernelControllerContext context : contexts) {
                    int contextStateIndex = states.indexOf(context.getState());
                    if (contextStateIndex < stateIndex) continue;
                    kccs.add(context);
                }
                Set<KernelControllerContext> set = Collections.unmodifiableSet(kccs);
                return set;
            }
            Set<KernelControllerContext> set = null;
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    public void addInstantiatedContext(KernelControllerContext context) {
        this.prepareToTraverse(context, true);
    }

    public void removeInstantiatedContext(KernelControllerContext context) {
        this.prepareToTraverse(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareToTraverse(KernelControllerContext context, boolean addition) {
        this.lockWrite();
        try {
            Object target = context.getTarget();
            if (target != null) {
                this.traverseBean(context, target.getClass(), addition, this.log.isTraceEnabled());
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    protected void traverseBean(KernelControllerContext context, Class<?> clazz, boolean addition, boolean trace) {
        Class<?>[] interfaces;
        if (clazz == null || clazz == Object.class) {
            return;
        }
        ClassContext classContext = this.contextsByClass.get(clazz);
        if (addition) {
            if (classContext == null) {
                classContext = new ClassContext();
                classContext.contexts = new HashSet();
                this.contextsByClass.put(clazz, classContext);
            } else if (classContext.used) {
                this.log.warn((Object)("Additional matching bean - contextual injection already used for class: " + clazz));
            }
            if (trace) {
                this.log.trace((Object)("Mapping contex " + context + " to class: " + clazz));
            }
            classContext.contexts.add(context);
        } else if (classContext != null) {
            if (trace) {
                this.log.trace((Object)("Removing contex " + context + " to class: " + clazz));
            }
            classContext.contexts.remove(context);
        }
        this.traverseBean(context, clazz.getSuperclass(), addition, trace);
        for (Class<?> intface : interfaces = clazz.getInterfaces()) {
            this.traverseBean(context, intface, addition, trace);
        }
    }

    public KernelControllerContext getContextByClass(Class<?> clazz) {
        Set<KernelControllerContext> contexts = this.getInstantiatedContexts(clazz);
        int numberOfMatchingBeans = 0;
        if (contexts != null) {
            numberOfMatchingBeans = contexts.size();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Checking for contextual injection, current matches: " + numberOfMatchingBeans + " - " + clazz));
        }
        if (numberOfMatchingBeans != 1) {
            if (numberOfMatchingBeans > 1) {
                this.log.warn((Object)("Multiple beans match class type: " + clazz));
            }
            return null;
        }
        return contexts.iterator().next();
    }

    private class ClassContext {
        private boolean used;
        private Set<KernelControllerContext> contexts;

        private ClassContext() {
        }
    }
}

