/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Set;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.ClassDependencyItem;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.util.HashCode;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackDependencyItem
extends ClassDependencyItem {
    private Cardinality cardinality;

    public CallbackDependencyItem(Object name, Class<?> demandClass, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        super(name, demandClass, whenRequired, dependentState);
        if (cardinality == null) {
            throw new IllegalArgumentException("Null cardinality.");
        }
        this.cardinality = cardinality;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    protected Set<KernelControllerContext> getContexts(Controller controller) {
        if (!(controller instanceof KernelController)) {
            throw new IllegalArgumentException("Controller not KernelController!");
        }
        KernelController kernelController = (KernelController)controller;
        return kernelController.getContexts(this.getDemandClass(), this.getDependentState());
    }

    public boolean resolve(Controller controller) {
        int size;
        Set<KernelControllerContext> contexts = this.getContexts(controller);
        int n = size = contexts != null ? contexts.size() : 0;
        if (this.cardinality.isInRange(size)) {
            this.setIDependOn(this.getIDependOn());
            if (contexts != null) {
                for (KernelControllerContext context : contexts) {
                    this.addDependsOnMe(controller, (ControllerContext)context);
                }
            }
            this.setResolved(true);
        } else {
            this.setResolved(false);
        }
        return this.isResolved();
    }

    public boolean unresolved(Controller controller) {
        if (this.getIDependOn() == null) {
            return true;
        }
        Set<KernelControllerContext> contexts = this.getContexts(controller);
        int size = contexts != null ? contexts.size() - 1 : 0;
        return !this.cardinality.isInRange(size);
    }

    protected int getHashCode() {
        int result = HashCode.generate((Object)this.getName());
        result += 3 * HashCode.generate((Object)this.getIDependOn());
        result += 7 * HashCode.generate((Object)this.getWhenRequired());
        result += 11 * HashCode.generate((Object)this.getDependentState());
        return result += 19 * HashCode.generate((Object)this.getCardinality());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CallbackDependencyItem)) {
            return false;
        }
        CallbackDependencyItem cdi = (CallbackDependencyItem)((Object)obj);
        if (CallbackDependencyItem.isDifferent(this.getName(), cdi.getName())) {
            return false;
        }
        if (CallbackDependencyItem.isDifferent(this.getIDependOn(), cdi.getIDependOn())) {
            return false;
        }
        if (CallbackDependencyItem.isDifferent(this.getWhenRequired(), cdi.getWhenRequired())) {
            return false;
        }
        if (CallbackDependencyItem.isDifferent(this.getDependentState(), cdi.getDependentState())) {
            return false;
        }
        return !CallbackDependencyItem.isDifferent(this.getCardinality(), cdi.getCardinality());
    }

    protected static boolean isDifferent(Object first, Object second) {
        if (first == null) {
            return second != null;
        }
        return !first.equals(second);
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" cardinality=" + this.cardinality);
    }

    public String toHumanReadableString() {
        return super.toString();
    }
}

