/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.props.vertex;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.kernel.plugins.deployment.props.DeploymentVertex;
import org.jboss.kernel.plugins.deployment.props.TreeVertex;
import org.jboss.kernel.plugins.deployment.props.VertexFactory;
import org.jboss.kernel.plugins.deployment.props.vertex.BaseDeploymentVertex;
import org.jboss.kernel.plugins.deployment.props.vertex.BeanVertexFactory;
import org.jboss.kernel.plugins.deployment.props.vertex.ClassVertexFactory;
import org.jboss.kernel.plugins.deployment.props.vertex.ComplexValueVertex;
import org.jboss.kernel.plugins.deployment.props.vertex.HolderVertexFactory;
import org.jboss.kernel.plugins.deployment.props.vertex.LevelVertexFactory;
import org.jboss.kernel.plugins.deployment.props.vertex.PropertyVertexFactory;
import org.jboss.kernel.plugins.deployment.props.vertex.SimpleValueVertex;
import org.jboss.logging.Logger;
import org.jboss.util.graph.Graph;
import org.jboss.util.graph.Vertex;
import org.jboss.util.graph.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVertexFactory
implements VertexFactory {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected Map<Integer, Set<LevelVertexFactory>> levelFactories = new HashMap<Integer, Set<LevelVertexFactory>>();

    public DefaultVertexFactory() {
        this.addLevelFactory(0, new BeanVertexFactory());
        this.addLevelFactory(1, new ClassVertexFactory());
        this.addLevelFactory(1, new PropertyVertexFactory());
        this.addLevelFactory(2, new HolderVertexFactory());
    }

    public void addLevelFactory(int level, LevelVertexFactory factory) {
        Set<LevelVertexFactory> factories = this.levelFactories.get(level);
        if (factories == null) {
            factories = new TreeSet<LevelVertexFactory>(LevelVertexFactory.COMPARATOR);
            this.levelFactories.put(level, factories);
        }
        factories.add(factory);
    }

    @Override
    public DeploymentVertex rootVertex() {
        return new BaseDeploymentVertex();
    }

    @Override
    public TreeVertex createVertex(int level, String name) {
        Set<LevelVertexFactory> factories = this.levelFactories.get(level);
        if (factories == null) {
            throw new IllegalArgumentException("No matching level factories: " + name + " / " + level);
        }
        for (LevelVertexFactory factory : factories) {
            TreeVertex vertex = factory.createVertex(name);
            if (vertex == null) continue;
            return vertex;
        }
        throw new IllegalArgumentException("No matching level factory: " + name + " / " + level);
    }

    protected boolean isValueComplex(String value) {
        return value.contains(".");
    }

    @Override
    public TreeVertex valueVertex(String value) {
        if (this.isValueComplex(value)) {
            return new ComplexValueVertex(value);
        }
        return new SimpleValueVertex(value);
    }

    @Override
    public Visitor<String> visitor() {
        return new Visitor<String>(){

            public void visit(Graph<String> g, Vertex<String> v) {
                if (DefaultVertexFactory.this.logger.isTraceEnabled()) {
                    DefaultVertexFactory.this.logger.trace(v);
                }
            }
        };
    }
}

