/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithLifecycle;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class GenericBeanFactoryPlainLifecycleDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryPlainLifecycleDependencyTestCase.suite(GenericBeanFactoryPlainLifecycleDependencyTestCase.class);
    }

    public GenericBeanFactoryPlainLifecycleDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryPlainLifecycleDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testGenericBeanFactoryPlainLifecycleDependencyCorrectOrder() throws Throwable {
        this.plainLifecycleDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBeanWithLifecycle bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithLifecycle bean2 = (SimpleBeanWithLifecycle)factory.createBean();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)1, (int)bean1.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)2, (int)bean1.startOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)3, (int)bean2.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)4, (int)bean2.startOrder);
    }

    public void plainLifecycleDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryPlainLifecycleDependencyWrongOrder() throws Throwable {
        this.plainLifecycleDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.CONFIGURED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        SimpleBeanWithLifecycle bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithLifecycle bean2 = (SimpleBeanWithLifecycle)factory.createBean();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)1, (int)bean1.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)2, (int)bean1.startOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)3, (int)bean2.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)4, (int)bean2.startOrder);
    }

    public void plainLifecycleDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryPlainLifecycleDependencyReinstall() throws Throwable {
        this.plainLifecycleDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBeanWithLifecycle bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithLifecycle bean2 = (SimpleBeanWithLifecycle)factory.createBean();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)1, (int)bean1.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)2, (int)bean1.startOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)3, (int)bean2.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)4, (int)bean2.startOrder);
        this.uninstall("Name1");
        this.assertContext("Name2", ControllerState.CONFIGURED);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)5, (int)bean1.stopOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)6, (int)bean1.destroyOrder);
        context1 = this.assertInstall(0, "Name1");
        bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        this.assertContext("Name2", ControllerState.INSTALLED);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)7, (int)bean1.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)8, (int)bean1.startOrder);
        this.uninstall("Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)-1, (int)bean1.stopOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)-1, (int)bean1.destroyOrder);
        context2 = this.assertInstall(1, "Name2");
        factory = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithLifecycle)factory.createBean();
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        this.assertContext("Name1", ControllerState.INSTALLED);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)9, (int)bean2.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)10, (int)bean2.startOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)7, (int)bean1.createOrder);
        GenericBeanFactoryPlainLifecycleDependencyTestCase.assertEquals((int)8, (int)bean1.startOrder);
    }

    public void plainLifecycleDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanWithLifecycle.class.getName());
        GenericBeanFactoryMetaData metaData2 = new GenericBeanFactoryMetaData("Name2", SimpleBeanWithLifecycle.class.getName());
        HashSet<AbstractDependencyMetaData> depends = new HashSet<AbstractDependencyMetaData>();
        depends.add(new AbstractDependencyMetaData((Object)"Name1"));
        metaData2.setDepends(depends);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }

    protected void setUp() throws Exception {
        super.setUp();
        SimpleBeanWithLifecycle.resetOrder();
    }
}

