/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class DemandTestCase
extends AbstractXMLTest {
    protected AbstractDemandMetaData getDemand(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set demands = bean.getDemands();
        DemandTestCase.assertNotNull((Object)demands);
        DemandTestCase.assertEquals((int)1, (int)demands.size());
        AbstractDemandMetaData demand = (AbstractDemandMetaData)demands.iterator().next();
        DemandTestCase.assertNotNull((Object)demand);
        return demand;
    }

    public void testDemand() throws Exception {
        AbstractDemandMetaData demand = this.getDemand("Demand.xml");
        DemandTestCase.assertEquals((Object)"Demand", (Object)demand.getDemand());
        DemandTestCase.assertEquals((Object)ControllerState.DESCRIBED, (Object)demand.getWhenRequired());
    }

    public void testDemandWithWhenRequired() throws Exception {
        AbstractDemandMetaData demand = this.getDemand("DemandWithWhenRequired.xml");
        DemandTestCase.assertEquals((Object)"Demand", (Object)demand.getDemand());
        DemandTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)demand.getWhenRequired());
    }

    public void testDemandWithTransformer() throws Exception {
        AbstractDemandMetaData demand = this.getDemand("DemandWithTransformer.xml");
        DemandTestCase.assertEquals((Object)"Demand", (Object)demand.getDemand());
        DemandTestCase.assertEquals((String)"default", (String)demand.getTransformer());
    }

    public void testDemandBadNoValue() throws Exception {
        try {
            this.unmarshalBean("DemandBadNoValue.xml");
            DemandTestCase.fail((String)"Should not be here");
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public static Test suite() {
        return DemandTestCase.suite(DemandTestCase.class);
    }

    public DemandTestCase(String name) {
        super(name);
    }
}

