/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class ParameterTestCase
extends AbstractXMLTest {
    protected ParameterMetaData getParameter(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        ConstructorMetaData constructor = bean.getConstructor();
        ParameterTestCase.assertNotNull((Object)constructor);
        List parameters = constructor.getParameters();
        ParameterTestCase.assertNotNull((Object)parameters);
        ParameterTestCase.assertEquals((int)1, (int)parameters.size());
        ParameterMetaData parameter = (ParameterMetaData)parameters.get(0);
        ParameterTestCase.assertNotNull((Object)parameter);
        return parameter;
    }

    public void testParameter() throws Exception {
        ParameterMetaData parameter = this.getParameter("Parameter.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        ParameterTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithBean() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithBean.xml");
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertBean(parameter.getValue());
    }

    public void testParameterWithClass() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithClass.xml");
        ParameterTestCase.assertEquals((String)"ParameterClass", (String)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        ParameterTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithAnnotation() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithAnnotation.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        this.assertAnnotations(expected, parameter.getAnnotations());
        ParameterTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithAnnotations() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithAnnotations.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation2");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation3");
        this.assertAnnotations(expected, parameter.getAnnotations());
        ParameterTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithPlainValue() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithPlainValue.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertPlainValue("PlainValue", parameter.getValue());
    }

    public void testParameterWithValue() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithValue.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertValue("Value", parameter.getValue());
    }

    public void testParameterWithInjection() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithInjection.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertInjection(parameter.getValue());
    }

    public void testParameterWithCollection() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithCollection.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertCollection(parameter.getValue());
    }

    public void testParameterWithList() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithList.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertList(parameter.getValue());
    }

    public void testParameterWithSet() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithSet.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertSet(parameter.getValue());
    }

    public void testParameterWithArray() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithArray.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertArray(parameter.getValue());
    }

    public void testParameterWithMap() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithMap.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertMap(parameter.getValue());
    }

    public void testParameterWithThis() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithThis.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertThis(parameter.getValue());
    }

    public void testParameterWithWildcard() throws Exception {
        ParameterMetaData parameter = this.getParameter("ParameterWithWildcard.xml");
        ParameterTestCase.assertNull((Object)parameter.getType());
        ParameterTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertWildcard(parameter.getValue());
    }

    public static Test suite() {
        return ParameterTestCase.suite(ParameterTestCase.class);
    }

    public ParameterTestCase(String name) {
        super(name);
    }
}

