/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class PropertyTestCase
extends AbstractXMLTest {
    protected PropertyMetaData getProperty(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        PropertyTestCase.assertNotNull((Object)properties);
        PropertyTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        PropertyTestCase.assertNotNull((Object)property);
        return property;
    }

    public void testProperty() throws Exception {
        PropertyMetaData property = this.getProperty("Property.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        PropertyTestCase.assertNull((Object)property.getValue());
    }

    public void testPropertyWithBean() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithBean.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        ValueMetaData value = property.getValue();
        this.assertBean(value);
    }

    public void testPropertyWithClass() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithClass.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        ValueMetaData value = property.getValue();
        PropertyTestCase.assertNotNull((Object)value);
        PropertyTestCase.assertTrue((boolean)(value instanceof StringValueMetaData));
        StringValueMetaData string = (StringValueMetaData)value;
        PropertyTestCase.assertEquals((String)"PropertyClass", (String)string.getType());
    }

    public void testPropertyWithAnnotation() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithAnnotation.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        this.assertAnnotations(expected, property.getAnnotations());
        PropertyTestCase.assertNull((Object)property.getValue());
    }

    public void testPropertyWithAnnotations() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithAnnotations.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation2");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation3");
        this.assertAnnotations(expected, property.getAnnotations());
        PropertyTestCase.assertNull((Object)property.getValue());
    }

    public void testPropertyWithPlainValue() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithPlainValue.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertPlainValue("PlainValue", property.getValue());
    }

    public void testPropertyWithPreInstantiate() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithPreInstantiate.xml");
        PropertyTestCase.assertFalse((String)"PreInstantiate should be false.", (boolean)property.isPreInstantiate());
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertPlainValue("PlainValue", property.getValue());
    }

    public void testPropertyWithValue() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithValue.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertValue("Value", property.getValue());
    }

    public void testPropertyWithInjection() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithInjection.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertInjection(property.getValue());
    }

    public void testPropertyWithCollection() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithCollection.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertCollection(property.getValue());
    }

    public void testPropertyWithList() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithList.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertList(property.getValue());
    }

    public void testPropertyWithSet() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithSet.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertSet(property.getValue());
    }

    public void testPropertyWithArray() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithArray.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertArray(property.getValue());
    }

    public void testPropertyWithMap() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithMap.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertMap(property.getValue());
    }

    public void testPropertyWithThis() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithThis.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertThis(property.getValue());
    }

    public void testPropertyWithWildcard() throws Exception {
        PropertyMetaData property = this.getProperty("PropertyWithWildcard.xml");
        PropertyTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyTestCase.assertNull((Object)property.getAnnotations());
        this.assertWildcard(property.getValue());
    }

    public void testPropertyBadNoName() throws Exception {
        try {
            this.unmarshalBean("PropertyBadNoName.xml");
            PropertyTestCase.fail((String)"Should not be here");
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public static Test suite() {
        return PropertyTestCase.suite(PropertyTestCase.class);
    }

    public PropertyTestCase(String name) {
        super(name);
    }
}

